-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Limit_G;
with JPATS_Landing_Gear,
  Jpats_Landing_Gear_Types,
  Jpats_Aircraft_Body;

package body Buffet is

   package Gear renames Jpats_Landing_Gear;
   package Gear_Types renames Jpats_Landing_Gear_Types;
   package Jab renames Jpats_Aircraft_Body;

   subtype Zero_to_One is  Normalized_Types.Normalize range 0.0 .. 1.0;

   function Magnitude_Limit is new Limit_G(Value_Type => Float,
                                           Limit_Type => Zero_to_One);

   procedure Set_Stall_Buffet (Calibrated_Airspeed :in     Length_Types.Knots;
                               Stall_Speed         :in     Length_Types.Knots;
                               Flap_Position       :in     Angle_Types.Degrees;
                               SABDS_Table           :in out Interpolation_Table.Singly_Indexed.Instance;
                               An_Instance           :in out Instance) is

      Stall_Buffet_Differential : Float              := 0.0;
      Buffet_Speed              : Length_Types.Knots := 0.0;
      Multiplier                : Float              := 0.30;
      Weight_On_Wheels          : Boolean            := False;

   begin

      Weight_On_Wheels := Jab.Get_Left_Wow;

      Stall_Buffet_Differential :=
        Interpolation_Table.Singly_Indexed.Interpolate(Flap_Position,SABDS_Table'access);

      Buffet_Speed := Stall_Speed + Stall_Buffet_Differential;

      if Weight_on_Wheels then
         An_Instance.The_Stall_Buffet_Magnitude := 0.0;
      else
         An_Instance.The_Stall_Buffet_Magnitude :=
           Magnitude_Limit(Multiplier * (Buffet_Speed - Calibrated_Airspeed));
      end if;

   end Set_Stall_Buffet;

   procedure Assign_Stall_Buffet
     (Init_Stall_Buffet_Magnitude :in     Normalized_Types.Normalize;
      An_Instance                         :in out Instance) is
   begin
      An_Instance.The_Stall_Buffet_Magnitude := Init_Stall_Buffet_Magnitude;
   end Assign_Stall_Buffet;

   function Get_Stall_Buffet(An_Instance :in Instance) return Normalized_Types.Normalize is
   begin
      return An_Instance.The_Stall_Buffet_Magnitude;
   end Get_Stall_Buffet;

end Buffet;
