-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Length_Types;

package Attitude_Angle is

   type Instance is private;

   procedure Set_Pitch(L_3         :in     Float ;
                       An_Instance :in out Instance);

   procedure Set_Pitch_from_E(E_1       :in     Float ;
                              E_2       :in     Float ;
                              E_3       :in     Float ;
                              E_4       :in     Float ;
                              An_Instance :in out Instance);

   procedure Assign_Pitch (Pitch_Angle :in     Angle_Types.Radians;
                           An_Instance      :in out Instance);

   function Get_Pitch(An_Instance :in Instance) return Angle_Types.Radians;

   procedure Set_Roll(N_3         :in     Float;
                      M_3         :in     Float;
                      An_Instance :in out Instance);

   procedure Assign_Roll (Roll_Angle :in     Angle_Types.Radians;
                          An_Instance             :in out Instance);

   function Get_Roll(An_Instance :in Instance) return Angle_Types.Radians;

   procedure Set_Hdg (L_1         :in     Float;
                      L_2         :in     Float;
                      An_Instance :in out Instance);

   procedure Assign_Hdg (Hdg_Angle :in     Angle_Types.Radians;
                         An_Instance    :in out Instance        );

   function Get_Hdg(An_Instance :in Instance) return Angle_Types.Radians;

private
   type Instance is
      record
         The_Roll_Angle  : Angle_Types.Radians := 0.0;
         The_Pitch_Angle : Angle_Types.Radians := 0.0;
         The_hdg_Angle   : Angle_Types.Radians := 297.8;
      end record;

end Attitude_Angle;
