-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--|
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;             use Ada.Numerics.Elementary_Functions;


package body Attitude_Angle is

   procedure Set_Pitch(L_3         :in     Float ;
                       An_Instance :in out Instance) is
      Temp : Float := L_3;
   begin
       if Temp > 1.0 then
          Temp := 1.0;
       elsif Temp < -1.0 then
           Temp := -1.0;
       end if;
       An_Instance.The_Pitch_Angle := Arcsin(-Temp);  --| sin-1 (sine inverse function)
   end Set_Pitch;

   procedure Set_Pitch_from_E(E_1         :in     Float ;
                              E_2         :in     Float ;
                              E_3         :in     Float ;
                              E_4         :in     Float ;
                              An_Instance :in out Instance) is
   begin
      An_Instance.The_Pitch_Angle := Arcsin(-2.0 * (E_4 * E_2 - E_1 * E_3));
   end Set_Pitch_from_E;

   procedure Assign_Pitch (Pitch_Angle :in     Angle_Types.Radians;
                           An_Instance :in out Instance) is
   begin
      An_Instance.The_Pitch_Angle := Pitch_Angle;
   end Assign_Pitch;

   function Get_Pitch(An_Instance :in Instance) return Angle_Types.Radians is
   begin
      return An_Instance.The_Pitch_Angle;
   end Get_Pitch;

   procedure Set_Roll(N_3         :in     Float;
                      M_3         :in     Float;
                      An_Instance :in out Instance) is
                      Temp : Float := N_3;
   begin
       if abs(Temp) <= 0.001 then
           Temp := 0.001;
       end if;
       An_Instance.The_Roll_Angle  := Arctan(M_3,Temp);
   end Set_Roll;

   procedure Assign_Roll (Roll_Angle   :in     Angle_Types.Radians;
                          An_Instance  :in out Instance) is
   begin
      An_Instance.The_Roll_Angle := Roll_Angle;
   end Assign_Roll;

   function Get_Roll(An_Instance :in Instance) return Angle_Types.Radians is
   begin
      return An_Instance.The_Roll_Angle;
   end Get_Roll;

   procedure Set_Hdg (L_1         :in     Float;
                      L_2         :in     Float;
                      An_Instance :in out Instance) is
       Temp : Float := L_1;
   begin
       if abs(Temp) <= 0.001 then
           Temp := 0.001;
       end if;
       An_Instance.The_Hdg_Angle := Arctan(L_2,Temp);
       if An_Instance.The_Hdg_Angle < 0.0 then
          An_Instance.The_Hdg_Angle := 6.283_185 + An_Instance.The_Hdg_Angle;
       end if;
   end Set_Hdg;

   procedure Assign_Hdg (Hdg_Angle    :in     Angle_Types.Radians;
                         An_Instance  :in out Instance) is
   begin
      An_Instance.The_Hdg_Angle := Hdg_Angle;
   end Assign_hdg;

   function Get_Hdg(An_Instance :in Instance) return Angle_Types.Radians is
   begin
      return An_Instance.The_Hdg_Angle;
   end Get_Hdg;

end Attitude_Angle;

