-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Mass_Types;
with Normalized_Types;
with Temperature_Types;
with Force_Types;
with Interpolation_Table.Singly_Indexed;

package Airspeed is
   package It renames Interpolation_Table;
   type Instance is private;

   procedure Set_True_Airspeed
            (Velocity_Body_Axes :in     Coordinate_Types.Cartesian;
             An_Instance        :in out Instance);

   procedure Set_True_Airspeed_based_on_Mach_Number
     (Ambient_Temperature :in     Temperature_Types.Rankine;
      An_Instance         :in out Instance);

   procedure Set_True_Airspeed_based_on_Indicated_Airspeed
     (Indicated_Airspeed    :in     Length_Types.Feet_per_Sec;
      SL_Density            :in     Mass_Types.Slugs_per_Cubic_Feet;
      Density_at_Altitude   :in     Mass_Types.Slugs_per_Cubic_Feet;
      An_Instance           :in out Instance);

   procedure Assign_True_Airspeed
         (True_Airspeed  :in     Length_Types.Feet_per_Sec;
          An_Instance    :in out Instance);

   function Get_True_Airspeed
         (An_Instance :in Instance) return Length_Types.Feet_per_Sec;

   procedure Set_Mach_Number
             (Ambient_Temperature :in     Temperature_Types.Rankine;
              An_Instance         :in out Instance);

   --| Set_Mach_Number_based_on_Calibrated_Airspeed; used when True
   --| airspeed is available
   procedure Set_Mach_Number_based_on_Calibrated_Airspeed
  --   (Ambient_Pressure_Ratio :in     Normalized_Types.Normalize;
     (Dens                  :in     Mass_Types.Slugs_per_Cubic_Feet;
      An_Instance            :in out Instance);

   procedure Assign_Mach_Number (Mach_Number :in Length_Types.Mach;
                                 An_Instance :in out Instance);

   function Get_Mach_Number(An_Instance :in Instance) return Length_Types.Mach;

   procedure Set_Calibrated_Airspeed
           (Dens         :in     float;
     --  Ambient_Pressure_Ratio :in     Normalized_Types.Normalize;
               An_Instance            :in out Instance);

   procedure Assign_Calibrated_Airspeed
               (Calibrated_Airspeed  :in     Length_Types.Knots;
                An_Instance          :in out Instance);

   function Get_Calibrated_Airspeed(An_Instance :in Instance) return Length_Types.Knots ;

   procedure Set_Rate_of_Climb
     (z_Vel              :in     Length_Types.Feet_per_Sec;
      An_Instance        :in out Instance);

   procedure Set_Rate_Of_Climb_For_Altitude_Freeze
                   (An_Instance :in out Instance);

   procedure Assign_Rate_Of_Climb
               (Rate_of_Climb :in Length_Types.Feet_per_Min;
                An_Instance   :in out Instance);

   function Get_Rate_of_Climb(An_Instance :in Instance) return Length_Types.Feet_per_Min;

   procedure Set_Ground_Speed
         (North_vel    :in     Length_Types.Feet_per_Sec;
          East_vel     :in     Length_Types.Feet_per_Sec;
          L_1          :in     Float;
          L_2          :in     Float;
          An_Instance  :in out Instance);

   procedure Assign_Ground_Speed
           (Ground_Speed   :in     Length_Types.Feet_per_Sec;
            An_Instance    :in out Instance);

   function Get_Ground_Speed(An_Instance :in Instance)
               return Length_Types.Feet_per_Sec ;

    procedure calc_Dynamic_Pressure
              (Air_Density     :in     Mass_Types.Slugs_per_Cubic_Feet;
               True_Airspeed   :in     Length_Types.Feet_per_Sec;
               An_Instance     :in out Instance);

    function dynamic_pressure(An_Instance :in Instance)
      return  Force_Types.Pounds_per_Sq_Feet;

   procedure Set_Stall_Speed(GW            :in     Mass_Types.Lbm;
                             Flap_Position :in     Angle_Types.Degrees;
                             z_Load_Factor :in     Float;
                             SASSB_Table   :in out It.Singly_Indexed.Instance;
                             SASSGWE_Table :in out It.Singly_Indexed.Instance;
                             An_Instance   :in out Instance);

   procedure Assign_Stall_Speed
                (Init_Load_Factor_Effect :in Float;
                 Init_Stall_Speed        :in Length_Types.Knots;
                 An_Instance             :in out Instance);

   function Get_Stall_Speed(An_Instance :in Instance)
                      return Length_Types.Knots;

private
   type Instance is
      record
         The_Rate_of_Climb       : Length_Types.Feet_Per_Min := 0.0;
         The_Load_Factor_Effect  : Float := 0.0;
         The_Mach_Number         : Length_Types.Mach := 0.0;
         The_Calibrated_Airspeed : Length_Types.Knots := 0.0;
         Sonic_Airspeed          : Length_Types.Feet_Per_Sec := 0.0;
         The_Stall_Speed         : Length_Types.Knots := 0.0;
         The_True_Airspeed       : Length_Types.Feet_Per_Sec := 0.0;
         The_True_Airspeed_Rate  : Float := 0.0;
         The_Ground_Speed        : Length_Types.Feet_Per_Sec := 0.0;
         The_Dynamic_Pressure    : Force_Types.Pounds_Per_Sq_Feet := 0.0;
      end record;

end Airspeed;
