-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Mass_Types;

package Aircraft_Weight is

   type Instance is private;

   procedure Set_Zero_Fuel (Weight_Basic       :in     Mass_Types.Lbm;
                            Weight_Student     :in     Mass_Types.Lbm;
                            Weight_Instructor  :in     Mass_Types.Lbm;
                            Weight_Baggage     :in     Mass_Types.Lbm;
                            An_Instance        :in out Instance);

   procedure Assign_Zero_Fuel (Zf_Weight     :in     Mass_Types.Lbm;
                               An_Instance   :in out Instance);

   function Get_Zero_Fuel(An_Instance :in Instance) return Mass_Types.Lbm;

   procedure Set_GW (Weight_Fuel           :in     Mass_Types.Lbm;
                     Weight_Ice            :in    Mass_Types.Lbm;
                     An_Instance           :in out Instance);

   procedure Assign_GW (GW              :in     Mass_Types.Lbm;
                        An_Instance     :in out Instance);

   function Get_GW(An_Instance :in Instance) return Mass_Types.Lbm;

   function Get_Mass(An_Instance :in Instance) return Mass_Types.Slugs_per_Cubic_Feet;

private
   type Instance is
      record
         The_Zero_Fuel    : Mass_Types.Lbm  := 5050.0;
         The_GW           : Mass_Types.Lbm  := 6150.0;
         The_Mass         : Mass_Types.Slugs_per_Cubic_Feet := 191.15 ;
      end record;

end Aircraft_Weight;









