-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Interpolation_Table.Doubly_Indexed;

package Aerodynamic_Angle is

   type Instance is private;

   procedure Set_Angle_of_Attack(V_B           :in     Coordinate_Types.Cartesian;
                                 An_Instance   :in out Instance);

   procedure Assign_Angle_of_Attack (Init_Angle_of_Attack :in     Angle_Types.Radians;
                                     An_Instance          :in out Instance);

   function Get_Angle_of_Attack(An_Instance :in Instance) return Angle_Types.Radians;

   procedure Set_Side_Slip_Angle(V_B         :in     Coordinate_Types.Cartesian;
                                 An_Instance :in out Instance);

   procedure Assign_Side_Slip_Angle (Init_Side_Slip_Angle :in     Angle_Types.Radians;
                                     An_Instance          :in out Instance);

   function Get_Side_Slip_Angle(An_Instance :in Instance) return Angle_Types.Radians;

   procedure Set_Angle_of_Attack_Rate(V_B             :in     Coordinate_Types.Cartesian;
                                      Linear_Accel    :in     Coordinate_Types.Cartesian;
                                      P               :in     Angle_Types.Radians_Per_Sec;
                                      Q               :in     Angle_Types.Radians_Per_Sec;
                                      R               :in     Angle_Types.Radians_Per_Sec;
                                      Pitch           :in     Angle_Types.Radians;
                                      Roll            :in     Angle_Types.Radians;
                                      An_Instance     :in out Instance);

   procedure Assign_Angle_of_Attack_Rate(Init_Angle_of_Attack_Rate :in     Angle_Types.Radians_per_Sec;
                                         An_Instance               :in out Instance);

   function Get_Angle_of_Attack_Rate(An_Instance :in Instance) return Angle_Types.Radians_per_Sec;

private
   type Instance is
      record
         The_Angle_of_Attack      : Angle_Types.Radians := 0.0;
         The_Side_Slip_Angle      : Angle_Types.Radians := 0.0;
         The_Angle_of_Attack_Rate : Angle_Types.Radians_per_Sec := 0.0;
      end record;

end Aerodynamic_Angle;

