-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;
with Ada.Numerics;

package body Aerodynamic_Angle is

   procedure Set_Angle_of_Attack(V_B         :in     Coordinate_Types.Cartesian;
                                 An_Instance :in out Instance) is
      Denom : Float := V_B.x;
   begin
      if abs(Denom) <= 0.001 then
         if Denom >= 0.0 then
            Denom := 0.001;
         else
            Denom := -0.001;
         end if;
      end if;
      An_Instance.The_Angle_of_Attack := Arctan(V_B.z / Denom);
      if Denom < 0.0 then -- going backwards
           if V_B.z >  0.0 then
              An_Instance.The_Angle_of_Attack := 3.1416 + An_Instance.The_Angle_Of_Attack;
           else
              An_Instance.The_Angle_of_Attack := -3.1416 + An_Instance.The_Angle_Of_Attack;
           end if;
      end if;
   end Set_Angle_of_Attack;

   procedure Assign_Angle_of_Attack (Init_Angle_of_Attack :in     Angle_Types.Radians;
                                     An_Instance          :in out Instance) is
   begin
      An_Instance.The_Angle_of_Attack := Init_Angle_of_Attack;
   end Assign_Angle_of_Attack;

   function Get_Angle_of_Attack(An_Instance :in Instance) return Angle_Types.Radians is
   begin
      return An_Instance.The_Angle_of_Attack;
   end Get_Angle_of_Attack;

   procedure Set_Side_Slip_Angle(V_B           :in     Coordinate_Types.Cartesian;
                                 An_Instance   :in out Instance) is
      Denom : Float := V_B.x;
   begin
       if abs(Denom) <= 0.001 then
         if Denom >= 0.0 then
            Denom := 0.001;
         else
            Denom := -0.001;
         end if;
      end if;

       --An_Instance.The_Side_Slip_Angle := Arctan(V_B.y / Denom);
       An_Instance.The_Side_Slip_Angle := Arctan(V_B.y / (Denom*Sqrt(1.0+(V_B.Z/Denom)**2)));
       if (Denom) < 0.0 then -- going backwards
           if V_B.y >  0.0 then
              An_Instance.The_Side_Slip_Angle :=  3.1416 + An_Instance.The_Side_Slip_Angle;
           else
              An_Instance.The_Side_Slip_Angle := -3.1416 + An_Instance.The_Side_Slip_Angle;
           end if;
      end if;
   end Set_Side_Slip_Angle;

   procedure Assign_Side_Slip_Angle (Init_Side_Slip_Angle :in     Angle_Types.Radians;
                                     An_Instance                  :in out Instance) is
   begin
      An_Instance.The_Side_Slip_Angle := Init_Side_Slip_Angle;
   end Assign_Side_Slip_Angle;

   function Get_Side_Slip_Angle(An_Instance :in Instance) return Angle_Types.Radians is
   begin
      return An_Instance.The_Side_Slip_Angle;
   end Get_Side_Slip_Angle;

   procedure Set_Angle_of_Attack_Rate(V_B             :in     Coordinate_Types.Cartesian;
                                      Linear_Accel    :in     Coordinate_Types.Cartesian;
                                      P               :in     Angle_Types.Radians_Per_Sec;
                                      Q               :in     Angle_Types.Radians_Per_Sec;
                                      R               :in     Angle_Types.Radians_Per_Sec;
                                      Pitch           :in     Angle_Types.Radians;
                                      Roll            :in     Angle_Types.Radians;
                                      An_Instance     :in out Instance) is
      Ax : Float := 0.0;
      Az : Float := 0.0;
   begin
      Ax := linear_accel.x  - 32.174 * Sin(Pitch) -
                                V_B.Z * Q + V_B.Y * R;
      Az := linear_accel.Z  + 32.174 * Cos(Roll) * Cos(Pitch) +
                                V_B.X * Q - V_B.Y * P;

      An_Instance.The_Angle_of_Attack_Rate := (V_B.x * Az - V_B.z * ax)
                                          /Float'Max((V_B.x**2 + V_B.z**2),0.01);
   end Set_Angle_of_Attack_Rate;

   procedure Assign_Angle_of_Attack_Rate(Init_Angle_of_Attack_Rate :in     Angle_Types.Radians_per_Sec;
                                         An_Instance               :in out Instance) is
   begin
      An_Instance.The_Angle_of_Attack_Rate := Init_Angle_of_Attack_Rate;
   end Assign_Angle_of_Attack_Rate;

   function Get_Angle_of_Attack_Rate(An_Instance :in Instance) return Angle_Types.Radians_per_Sec is
   begin
      return An_Instance.The_Angle_of_Attack_Rate;
   end Get_Angle_of_Attack_Rate;

end Aerodynamic_Angle;



