-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
---------------------------------------------------------------------------
with Angle_Types;
with Coordinate_Types;
with Mass_Types;

package Acceleration is

   type Instance is private;

   function Get_Body_Axis
     (An_Instance :in Instance)
     return Coordinate_Types.Cartesian;

   function Load_Factor
     (An_Instance :in Instance)
     return Coordinate_Types.Cartesian;

   procedure Assign_Load_Factor
     (An_Instance : in out Instance;
      Load_Factor : in     Coordinate_Types.Cartesian);

   procedure Calc_linear  --|  Translational Accelerations & load factor
     (Force       :in     Coordinate_Types.Cartesian;
      Roll_Angle  :in     Angle_Types.Radians;
      Pitch_Angle :in     Angle_Types.Radians;
      Yaw_Angle   :in     Angle_Types.Radians;
      Mass        :in     Mass_Types.Slugs_per_Cubic_Feet;
      Stopped     :in     Boolean;
      An_Instance :in out Instance);

   function Get_Earth_Axis(An_Instance :in Instance)
                  return Coordinate_Types.Cartesian ;

   function Get_Last_Pass_Earth_Axis(An_Instance :in Instance)
                  return Coordinate_Types.Cartesian;

   --| calc Angular Acceleration in Body axis
   procedure Calc_Ang_Acc(Moment        :in     Coordinate_Types.Cartesian;
                         Inertia      :in     Coordinate_Types.Inertia_Axis;
                         Angular_Rate :in     Coordinate_Types.Attitude;
                         An_Instance     :in out Instance);

   function Get_Angular(An_Instance :in Instance)
                        return Coordinate_Types.Attitude;

   function Get_Last_Pass_Angular(An_Instance :in Instance)
                        return Coordinate_Types.Attitude;

private
   type Instance is
      record
        The_Acc_Body            : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
        The_Acc_Earth           : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
        The_Last_Pass_Acc_Earth : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
        The_Ang                 : Coordinate_Types.Attitude := (0.0,0.0,0.0);
        The_Last_Pass_Ang       : Coordinate_Types.Attitude := (0.0,0.0,0.0);
        The_Load_Factor         : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
      end record;
end Acceleration;
