-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls_Types;
with Electrical_Units_Types;
--with Velocity_Types;
with Angle_Types;
--with Altitude_Types;
with Length_Types;

package Tad is
   type Instance is private;

   procedure Read_Tables;

   function Tad_Command
     (An_Instance : in Instance)
      return Float;
   function Tad_On
     (An_Instance : in Instance)
      return Boolean;
   function Tad_Fail
     (An_Instance : in Instance)
      return Boolean;

   procedure update
     (An_Instance                   : in out Instance;
      Iconst                        : in     Float;
      Left_Wow_Relay                : in     Boolean;
      Right_Wow_Relay               : in     Boolean;
      Tad_Cb                        : in     Boolean;
      Kias_Adc                      : in     Length_Types.Knots;
      Pitch_Rate                    : in     Angle_Types.Radians_per_Sec;
      Pressure_Altitude             : in     Length_Types.Feet;
      Engine_Torque                 : in     Float;
      Rudder_Trim_Actuated_Position : in     Jpats_Secondary_Flight_Controls_Types.Rudder_Trim_Position_Type;
      Trim_Disconnect               : in     Boolean;
      Trim_Interrupt                : in     Boolean;
      Tad_Fault                     : in     Boolean;
      Rudder_Trim_Switch_Left       : in     Boolean;
      Rudder_Trim_Switch_Right      : in     Boolean;
      Tad_On_Switch                 : in     Boolean);

   procedure Initialize
     (An_Instance : in out Instance);

private
   type Instance is
      record
         Is_Powered    : Boolean;
         In_Air        : Boolean;
         Map_Base      : Float;
         Map_Command   : Float;
         Pilot_Command : Float;
         Tad_Command   : Float;
         Tad_Fail      : Boolean;
         Tad_On        : Boolean;
      end record;
end Tad;
