-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls_Types;

with Jpats_Hydraulics_Types;
with Electrical_Units_Types;
with Force_Types;
with Length_Types;

package Speedbrake is

   type Instance is private;

   procedure Read_Tables;

   procedure Initialize
     (An_Instance : in out Instance);

   function Position
     (An_Instance : in Instance)
      return Jpats_Secondary_Flight_Controls_Types.Speedbrake_Position_Type;

   function Hydraulic_Load
     (An_Instance : in Instance)
      return Length_Types.Gpm;

   function Load
     (An_Instance : in Instance)
      return Electrical_Units_Types.Amps;

   procedure Update
     (An_Instance    : in out Instance;
      Iconst         : in     Float;
      Flaps_Sel_Up   : in     Boolean;
      Pcl_Max        : in     Boolean;
      Electrical_Pwr : in     Boolean;
      Hyd_Fcn        : in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
      Dynamic_Px     : in     Force_Types.Pounds_per_Sq_Feet;
      Switch_Extend  : in     Boolean;
      Switch_Retract : in     Boolean);

private

   type Instance is
      record
         Position          : Jpats_Secondary_Flight_Controls_Types.Speedbrake_Position_Type;
         Hydraulic_Load    : Length_Types.Gpm;
         Load              : Electrical_Units_Types.Amps;
         Position_Demanded : Jpats_Secondary_Flight_Controls_Types.Speedbrake_Position_Type;
      end record;

end Speedbrake;
