-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Singly_Indexed;
with Simulation_Dictionary;
with Log;

package body Speedbrake is

   sbuprt : aliased Interpolation_Table.Singly_Indexed.Instance;
   sbdnrt : aliased Interpolation_Table.Doubly_Indexed.Instance;

   procedure Read_Tables
   is
   begin
      Interpolation_Table.Read
        (File_Name => Simulation_Dictionary.Lookup ("SFC_Dir") & "sbdnrt.ito",
         Table     => sbdnrt);
      Interpolation_Table.Read
        (File_Name => Simulation_Dictionary.Lookup ("SFC_Dir") & "sbuprt.ito",
         Table     => sbuprt);
   exception
      when others =>
         Log.Report("Speedbrake.Read_Tables()");
         raise;
   end Read_Tables;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Position          := 0.0;
      An_Instance.Hydraulic_Load    := 0.0;
      An_Instance.Load              := 0.0;
      An_Instance.Position_Demanded := 0.0;
   exception
      when others =>
         Log.Report("Speedbrake.Initialize()");
         raise;
   end Initialize;

   function Position
     (An_Instance : in Instance)
      return Jpats_Secondary_Flight_Controls_Types.Speedbrake_Position_Type is
   begin
      return An_Instance.Position;
   exception
      when others =>
         Log.Report("Speedbrake.Position()");
         raise;
   end Position;

   function Hydraulic_Load
     (An_Instance : in Instance)
      return Length_Types.Gpm is
   begin
      return An_Instance.Hydraulic_Load;
   exception
      when others =>
         Log.Report("Speedbrake.Hydraulic_Load()");
         raise;
   end Hydraulic_Load;

   function Load
     (An_Instance : in Instance)
      return Electrical_Units_Types.Amps is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report("Speedbrake.Load()");
         raise;
   end Load;

   procedure Update
     (An_Instance    : in out Instance;
      Iconst         : in     Float;
      Flaps_Sel_Up   : in     Boolean;
      Pcl_Max        : in     Boolean;
      Electrical_Pwr : in     Boolean;
      Hyd_Fcn        : in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
      Dynamic_Px     : in     Force_Types.Pounds_per_Sq_Feet;
      Switch_Extend  : in     Boolean;
      Switch_Retract : in     Boolean) is

      package Sfc_T renames Jpats_Secondary_Flight_Controls_Types;
      package Double renames Interpolation_Table.Doubly_Indexed;
      package Single renames Interpolation_Table.Singly_Indexed;

      Old_Position          : constant Sfc_T.Speedbrake_Position_Type := An_Instance.Position;
      Old_Position_Demanded : constant Sfc_T.Speedbrake_Position_Type := An_Instance.Position_Demanded;

      Extend_Rate : Float := 0.0;
      Retract_Rate : Float := 0.0;
   begin

      if Switch_Retract or Pcl_Max or not Flaps_Sel_Up or Hyd_Fcn = 0.0 or not Electrical_Pwr then
         An_Instance.Position_Demanded := 0.0;
      elsif Switch_Extend then
         An_Instance.Position_Demanded := 1.0;
      else
         An_Instance.Position_Demanded := Old_Position_Demanded;
      end if;


--       if Hyd_Fcn = 0.0 or not Electrical_Pwr then
--          An_Instance.Position       := (Sfc_T.Speedbrake_Position_Type'Max
--                                         (0.0, Old_Position - 0.008 * Dynamic_Px * Iconst));
--          An_Instance.Hydraulic_Load := 0.0;
--          An_Instance.Load           := 0.0;
--       elsif An_Instance.Position_Demanded = 1.0 then
--          Extend_Rate := Double.Interpolate (Float(An_Instance.Position), Float(Dynamic_Px), Sbdnrt'Access);
--          An_Instance.Position       := (Sfc_T.Speedbrake_Position_Type'Min
--                                         (1.0, Old_Position + Hyd_Fcn * Extend_Rate * Iconst));
--          An_Instance.Hydraulic_Load := 3.5 * (An_Instance.Position - Old_Position);
--          An_Instance.Load           := 0.465;
--       else
--          Retract_Rate := Single.Interpolate (Float(An_Instance.Position), Sbuprt'Access);
--          An_Instance.Position       := (Sfc_T.Speedbrake_Position_Type'Max
--                                         (0.0, Old_Position + Hyd_Fcn * Retract_Rate * Iconst));
--          An_Instance.Hydraulic_Load := -2.06 * (An_Instance.Position - Old_Position);
--          An_Instance.Load           := 0.465;
--       end if;

      if Hyd_Fcn = 0.0 or not Electrical_Pwr then
         An_Instance.Position       := (Sfc_T.Speedbrake_Position_Type'Max
                                        (0.0, Old_Position - 0.008 * Dynamic_Px * Iconst));
         An_Instance.Hydraulic_Load := 0.0;
         An_Instance.Load           := 0.0;
      elsif An_Instance.Position_Demanded = 1.0 then
         Extend_Rate := Double.Interpolate (Float(An_Instance.Position), Float(Dynamic_Px), Sbdnrt'Access);
         An_Instance.Position       := (Sfc_T.Speedbrake_Position_Type'Min
                                        (1.0, Old_Position + Hyd_Fcn * Extend_Rate * Iconst));
         -- ****************** add c*16  ***********************
         An_Instance.Hydraulic_Load := (3.5 + 56.0)  * (An_Instance.Position - Old_Position);
         An_Instance.Load           := 0.465;
      else
         Retract_Rate := Single.Interpolate (Float(An_Instance.Position), Sbuprt'Access);
         An_Instance.Position       := (Sfc_T.Speedbrake_Position_Type'Max
                                        (0.0, Old_Position + Hyd_Fcn * Retract_Rate * Iconst));
         -- ****************** subtract c*16  ***********************
         An_Instance.Hydraulic_Load := (-2.06 - 32.96) * (An_Instance.Position - Old_Position);
         An_Instance.Load           := 0.465;
      end if;


--       if Hyd_Fcn = 0.0 or not Electrical_Pwr then
--          An_Instance.Position       := (Sfc_T.Speedbrake_Position_Type'Max
--                                         (0.0, Old_Position - 0.008 * Dynamic_Px * Iconst));
--          An_Instance.Hydraulic_Load := 0.0;
--          An_Instance.Load           := 0.0;
--       elsif An_Instance.Position_Demanded = 1.0 then
--          An_Instance.Position       := (Sfc_T.Speedbrake_Position_Type'Min
--                                         (1.0, Old_Position + Hyd_Fcn * (1.0 - 0.001 * Dynamic_Px) * Iconst));
--          An_Instance.Hydraulic_Load := 3.5 * (An_Instance.Position - Old_Position) * Iconst;
--          An_Instance.Load           := 0.465;
--       else
--          An_Instance.Position       := (Sfc_T.Speedbrake_Position_Type'Max
--                                         (0.0, Old_Position - Hyd_Fcn * (1.0 + 0.001 * Dynamic_Px) * Iconst));
--          An_Instance.Hydraulic_Load := -2.06 * (An_Instance.Position - Old_Position) * Iconst;
--          An_Instance.Load           := 0.465;
--       end if;

   exception
      when others =>
         Log.Report("Speedbrake.Update()");
         raise;
   end Update;

end Speedbrake;







