-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls_Types;

with Electrical_Units_Types;

package Rudder_Trim is

   type Instance is private;

   procedure Initialize
     (An_Instance : in out Instance);

   function Position
     (An_Instance : in Instance)
      return Float;

   function Load
     (An_Instance : in Instance)
      return Electrical_Units_Types.Amps;

   function Actuated_Position
     (An_Instance : in Instance)
      return Float;

   procedure Set_Position
     (An_Instance  : in out Instance;
      Tab_Position : in     Float;
      Rudder_Angle : in     Float);

   procedure Update
     (An_Instance              : in out Instance;
      Iconst                   : in     Float;
      Rud_Trim_Cb              : in     Boolean;
      Tad_On                   : in     Boolean;
      Trim_Interrupt           : in     Boolean;
      Trim_Disconnect          : in     Boolean;
      Tad_Command              : in     Float;
      Rudder_Trim_Switch_Left  : in     Boolean;
      Rudder_Trim_Switch_Right : in     Boolean;
      Rudder_Angle             : in     Float;
      Trim_Fail_Malf           : in     Boolean;
      Full_Right_Malf          : in     Boolean);

private

   type Instance is
      record
         Actuated_Position           : Float;
         Actuated_Position_Commanded : Float;
         Position                    : Float;
         Load                        : Electrical_Units_Types.Amps;
      end record;

end Rudder_Trim;
