-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls_Types;
with Electrical_Units_Types;
with Length_Types;


package Jpats_Secondary_Flight_Controls is

   function Mean_Flap_Position return Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
   function Flap_Buffet return Jpats_Secondary_Flight_Controls_Types.Buffet_Type;
   function Delta_Flap_Asymmetry return Jpats_Secondary_Flight_Controls_Types.Flap_Asymmetry_Type;

   function Speedbrake_Position return Jpats_Secondary_Flight_Controls_Types.Speedbrake_Position_Type;
   function Speedbrake_Buffet return Jpats_Secondary_Flight_Controls_Types.Buffet_Type;

   function Aileron_Trim_Position return Jpats_Secondary_Flight_Controls_Types.Aileron_Trim_Position_Type;
   function Elevator_Trim_Position return Jpats_Secondary_Flight_Controls_Types.Elevator_Trim_Position_Type;
   function Rudder_Trim_Position return Jpats_Secondary_Flight_Controls_Types.Rudder_Trim_Position_Type;

   function Elevator_Trim_Actuator_Position return Float;

   function TAD_FAIL_Annunciator_Request return Boolean;
   function TRIM_OFF_Annunciator_Request return Boolean;
   function TAD_OFF_Annunciator_Request return Boolean;

   function Speedbrake_Hydraulic_Load return Length_Types.Gpm;
   function Flaps_Hydraulic_Load return Length_Types.Gpm;

   function Aileron_Trim_Load return Electrical_Units_Types.Amps;
   function Elevator_Trim_Load return Electrical_Units_Types.Amps;
   function Rudder_Trim_Load return Electrical_Units_Types.Amps;
   function Speedbrake_Electrical_Load return Electrical_Units_Types.Amps;
   function Flaps_Electrical_Load return Electrical_Units_Types.Amps;
   function Primary_Flap_Selector_Manifold_Load return Electrical_Units_Types.Amps;
   function Emergency_Flap_Selector_Manifold_Load return Electrical_Units_Types.Amps;

   -- sound
   function Flap_Position_Sound return Float;
   function Speedbrake_Position_Snd return Float;

   --
   function Tad_On return Boolean;

   -- cnia
   function Flap_Handle_Up return Boolean;
   function Flap_Handle_Landing return Boolean;

   -- ios pilot
   --function Ios_Pilot_Enable return Boolean;
   function Ios_Pilot_Flaps  return Integer;
   function Ios_Pilot_Speed_Brake return Integer;

end Jpats_Secondary_Flight_Controls;
