-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls.Container;
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Aircraft_Flaps;
with Speedbrake;
with Aileron_Trim;
with Elevator_Trim;
with Rudder_Trim;
with Tad;
with Log;
with Length_Types;

package body Jpats_Secondary_Flight_Controls is


   function Mean_Flap_Position
     return Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type
   is
      package Ctnr renames Container;
   begin
      return Aircraft_Flaps.Deflection (Ctnr.This_Subsystem.The_Flaps);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Mean_Flap_Position()");
         raise;
   end Mean_Flap_Position;

   function Flap_Buffet
     return Jpats_Secondary_Flight_Controls_Types.Buffet_Type
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Buffet_Flap.Buffet (Ctnr.This_Subsystem.The_Flap_Buffet);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Flap_Buffet()");
         raise;
   end Flap_Buffet;

   function Delta_Flap_Asymmetry
     return Jpats_Secondary_Flight_Controls_Types.Flap_Asymmetry_Type
   is
      package Ctnr renames Container;
   begin
      return Aircraft_Flaps.Asymmetry (Ctnr.This_Subsystem.The_Flaps);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Delta_Flap_Asymmetry()");
         raise;
   end Delta_Flap_Asymmetry;



   function Speedbrake_Position
     return Jpats_Secondary_Flight_Controls_Types.Speedbrake_Position_Type
   is
      package Ctnr renames Container;
   begin
      return Speedbrake.Position (Ctnr.This_Subsystem.The_Speedbrake);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Speedbrake_Position()");
         raise;
   end Speedbrake_Position;

   function Speedbrake_Buffet
     return Jpats_Secondary_Flight_Controls_Types.Buffet_Type
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Buffet_Speedbrake.Buffet (Ctnr.This_Subsystem.The_Speedbrake_Buffet);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Speedbrake_Buffet()");
         raise;
   end Speedbrake_Buffet;


   function Aileron_Trim_Position
     return Jpats_Secondary_Flight_Controls_Types.Aileron_Trim_Position_Type
   is
      package Ctnr renames Container;
   begin
      return Aileron_Trim.Position (Ctnr.This_Subsystem.The_Aileron_Trim);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Aileron_Trim_Position()");
         raise;
   end Aileron_Trim_Position;

   function Elevator_Trim_Position
     return Jpats_Secondary_Flight_Controls_Types.Elevator_Trim_Position_Type
   is
      package Ctnr renames Container;
   begin
      return Elevator_Trim.Position (Ctnr.This_Subsystem.The_Elevator_Trim);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Elevator_Trim_Position()");
         raise;
   end Elevator_Trim_Position;

   function Rudder_Trim_Position
     return Jpats_Secondary_Flight_Controls_Types.Rudder_Trim_Position_Type
   is
      package Ctnr renames Container;
   begin
      return Rudder_Trim.Position (Ctnr.This_Subsystem.The_Rudder_Trim);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Rudder_Trim_Position()");
         raise;
   end Rudder_Trim_Position;


   function TAD_FAIL_Annunciator_Request
     return Boolean
   is
      package Ctnr renames Container;
      The_Tad : Tad.Instance renames Ctnr.This_Subsystem.The_Tad;
   begin
      return Tad.Tad_Fail (The_Tad);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.TAD_FAIL_Annunciator_Request()");
         raise;
   end TAD_FAIL_Annunciator_Request;

   function TRIM_OFF_Annunciator_Request
     return Boolean
   is
      package Ctnr  renames Container;
      package Ele   renames Jpats_Electrical;
      package Ele_T renames Jpats_Electrical_Types;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
      Trim_Interrupt_Relay : constant Boolean := (Io.Trim_Interrupt_Sw and
                                                  not Io.Trim_Disconnect_Sw and
                                                  Ele.Is_Powered (Ele_T.Rud_Trim_Cb));
   begin
      return not (not Trim_Interrupt_Relay and
                  not Io.Trim_Disconnect_Sw and
                  Ele.Is_Powered (Ele_T.Ail_El_Trim_Cb));
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.TRIM_OFF_Annunciator_Request()");
         raise;
   end TRIM_OFF_Annunciator_Request;

   function TAD_OFF_Annunciator_Request
     return Boolean
   is
      package Ctnr renames Container;
      The_Tad : Tad.Instance renames Ctnr.This_Subsystem.The_Tad;
   begin
      return not Tad.Tad_On (The_Tad);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.TAD_OFF_Annunciator_Request()");
         raise;
   end TAD_OFF_Annunciator_Request;


   function Speedbrake_Hydraulic_Load
     return Length_Types.Gpm
   is
      package Ctnr renames Container;
   begin
      return Speedbrake.Hydraulic_Load (Ctnr.This_Subsystem.The_Speedbrake);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Speedbrake_Hydraulic_Load()");
         raise;
   end Speedbrake_Hydraulic_Load;

   function Flaps_Hydraulic_Load
     return Length_Types.Gpm
   is
      package Ctnr renames Container;
   begin
      return Aircraft_Flaps.Hydraulic_Load (Ctnr.This_Subsystem.The_Flaps);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Flaps_Hydraulic_Load()");
         raise;
   end Flaps_Hydraulic_Load;


   function Aileron_Trim_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Aileron_Trim.Load (Ctnr.This_Subsystem.The_Aileron_Trim);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Aileron_Trim_Load()");
         raise;
   end Aileron_Trim_Load;

   function Elevator_Trim_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Elevator_Trim.Load (Ctnr.This_Subsystem.The_Elevator_Trim);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Elevator_Trim_Load()");
         raise;
   end Elevator_Trim_Load;

   function Rudder_Trim_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Rudder_Trim.Load (Ctnr.This_Subsystem.The_Rudder_Trim);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Rudder_Trim_Load()");
         raise;
   end Rudder_Trim_Load;

   function Speedbrake_Electrical_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Speedbrake.Load (Ctnr.This_Subsystem.The_Speedbrake);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Speedbrake_Electrical_Load()");
         raise;
   end Speedbrake_Electrical_Load;

   function Flaps_Electrical_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return Aircraft_Flaps.Load (Ctnr.This_Subsystem.The_Flaps);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Flaps_Electrical_Load()");
         raise;
   end Flaps_Electrical_Load;

   function Primary_Flap_Selector_Manifold_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return 1.0;
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Primary_Flap_Selector_Manifold_Load()");
         raise;
   end Primary_Flap_Selector_Manifold_Load;

   function Emergency_Flap_Selector_Manifold_Load
     return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
   begin
      return 1.0;
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Emergency_Flap_Selector_Manifold_Load()");
         raise;
   end Emergency_Flap_Selector_Manifold_Load;

   -- sound

   package Ctnr renames Container;
   Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;

   function Flap_Position_Sound
     return Float
   is
   begin
      return Sound.Flap_Position_Sound;
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Flap_Position_Sound()");
         raise;
   end Flap_Position_Sound;

   function Speedbrake_Position_Snd
     return Float
   is
   begin
      return Sound.Speedbrake_Position;
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Flap_Position_Sound()");
         raise;
   end Speedbrake_Position_Snd;


   --
   function Tad_On
     return Boolean
   is
      package Ctnr renames Container;
   begin
      return Tad.Tad_On(Ctnr.This_Subsystem.The_Tad);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Tad_On()");
         raise;
   end Tad_On;

   function Flap_Handle_Up
     return Boolean
   is
      Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;
   begin
      return Io.Flap_Cont_Up_Sw;
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Flap_Handle_Up()");
         raise;
   end Flap_Handle_Up;


   function Flap_Handle_Landing
     return Boolean
   is
      Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;
   begin
      return not (Io.Flap_Cont_Up_Sw or Io.Flap_Cont_To_Sw);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Flap_Handle_Landing()");
         raise;
   end Flap_Handle_Landing;

   function Elevator_Trim_Actuator_Position
     return Float
   is
   begin
      return Elevator_Trim.Actuated_Position(Container.This_Subsystem.The_Elevator_Trim);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Elevator_Trim_Actuator_Position()");
         raise;
   end Elevator_Trim_Actuator_Position;

   -- ios pilot
--     function Ios_Pilot_Enable
--       return Boolean
--     is
--        package Ctnr  renames Container;
--        Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
--     begin
--        return Ios.Ios_Pilot_Enable;
--     exception
--        when others =>
--           Log.Report("Jpats_Secondary_Flight_Controls.Ios_Pilot_Enable()");
--           raise;
--     end Ios_Pilot_Enable;

   function Ios_Pilot_Flaps
     return Integer
   is
      package Ctnr  renames Container;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   begin
      return Ios.Ios_Pilot_Flaps;
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Pilot_Flaps()");
         raise;
   end Ios_Pilot_Flaps;

   function Ios_Pilot_Speed_Brake
     return Integer
   is
      package Ctnr  renames Container;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   begin
      return Ios.Ios_Pilot_Speed_Brake;
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Pilot_Speed_Brake()");
         raise;
   end Ios_Pilot_Speed_Brake;



end Jpats_Secondary_Flight_Controls;
