-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  SPEED BRAKE SYSTEM
--  The speed brake control system operates a single ventral
--  plate, located between the flaps, through a hydraulic actuator
--  (Figure 1-23). A speed brake indicator, placarded
--  SPEED BRAKE, is provided on the left side of each instrument
--  panel. The indicator is illuminated any time the speed
--  brake is extended.
--  A system of cables, pulleys, and push-pull flexible cables
--  connected from the speed brake to the elevator trim tab actuator
--  automatically inputs pitch trim as the speed brake is
--  operated, and counteracts the pitch change tendency of the
--  aircraft due to the operation of the speed brake. The speed
--  brake will extend to 70 from the stowed position, and may
--  not be stopped at an intermediate deflection.
--  The speed brake switch (Figure 1-11) is a three-position
--  switch spring-loaded to the center position, located on the
--  top inside surface of each PCL. Rearward movement of
--  either switch extends the speed brake and forward movement
--  retracts the speed brake. If the flaps are extended, the
--  speed brake will not extend. Once extended, the speed brake
--  remains extended until either switch is moved forward to
--  retract, the flaps are extended, or the PCL is moved to
--  MAX. Moving the FLAPS selector out of the UP position,
--  or moving the PCL to the maximum power position, trips a
--  microswitch which automatically retracts the speed brake.
--  The speed brake control circuit responds to the last entry.
--  Electrical power for the speed brake system is provided
--  through a circuit breaker placarded SPEED BRAKE, on the
--  generator bus circuit breaker panel in the front cockpit.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------

private package Jpats_Secondary_Flight_Controls.Speedbrake_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Secondary_Flight_Controls.Speedbrake_Controller;
