-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls.Container;

with Jpats_Electrical;
with Jpats_Hydraulics;
with Jpats_Auto_Test;
with Jpats_Simulated_Aircraft;
with Jpats_Powerplant;
with Jpats_Secondary_Flight_Controls_Types;
with Jpats_Hydraulics_Types;
with Jpats_Electrical_Types;
with Jpats_Lights;
with Force_Types;
with Jpats_Landing_Gear;
with Log;

with Jpats_IOS_Pilot;

with Speedbrake;

package body Jpats_Secondary_Flight_Controls.Speedbrake_Controller is

   procedure Initialize is
   begin
      Speedbrake.Initialize (Container.This_Subsystem.The_Speedbrake);
      Speedbrake.Read_Tables;
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Speedbrake_Controller.Initialize()");
         raise;
   end Initialize;

   procedure Update
     (Iconst : in Float) is

      package Ctnr      renames Container;
      package Sfc_T     renames Jpats_Secondary_Flight_Controls_Types;
      package Auto_Test renames Jpats_Auto_Test;
      package Ele       renames Jpats_Electrical;
      package Ele_T     renames Jpats_Electrical_Types;
      package Hyd       renames Jpats_Hydraulics;
      package Hyd_T     renames Jpats_Hydraulics_Types;
      package Sac       renames Jpats_Simulated_Aircraft;
      package Lights    renames Jpats_Lights;
      package Jip       renames Jpats_IOS_Pilot;
      package Gear      renames Jpats_Landing_Gear;

      Auto_Test_Selected          : constant Boolean := Auto_Test.On;
      Auto_Test_Position_Demanded : constant Boolean := Auto_Test.sb_switch;

      The_Speedbrake : Speedbrake.Instance renames Ctnr.This_Subsystem.The_Speedbrake;

      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
      Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;


      Switch_Extend    : Boolean := Io.Speed_Brake_Extend_Sw;
      Switch_Retract   : Boolean := Io.Speed_Brake_Retract_Sw;

      Flap_Sel_Up      : constant Boolean := Io.Flap_Cont_Up_Sw;
      Pcl_Max_Sw       : constant Boolean := Jpats_Powerplant.Speed_Brake_Max_Power_Switch;
      Speedbrake_Cb    : constant Boolean := Ele.Is_Powered (Ele_T.Speedbrake_Cb);

      Hyd_Fcn          : Hyd_T.Normalized_Pressure_Type := Hyd.Primary_System_Pressure_Function;

      Dynamic_Pressure : Force_Types.Pounds_per_Sq_Feet := Sac.Get_Dynamic_Pressure;

      Ios_Pilot_Enable : constant Boolean := Jip.Ios_Pilot_Enable;
      Ios_Pilot_Speed_Brake : constant Integer := Ios.Ios_Pilot_Speed_Brake;
      Ios_Pilot_Flaps  : constant Integer := Ios.Ios_Pilot_Flaps;
      Emerg_Gear_Handle_Extend : constant Boolean := Gear.Emergency_Gear_Handle_Extended;

   begin

      if Emerg_Gear_Handle_Extend then
         Hyd_Fcn := 0.0;
      end if;

      if Auto_Test_Selected then

         if not Auto_Test_Position_Demanded  then
            Switch_Extend  := False;
            Switch_Retract := True;
         elsif Auto_Test_Position_Demanded  then
            Switch_Extend  := True;
            Switch_Retract := False;
         end if;

         Speedbrake.Update
           (An_Instance    => The_Speedbrake,   -- in out Instance
            Iconst         => Iconst,           -- in     Float
            Flaps_Sel_Up   => True, --Flap_Sel_Up,      -- in     Boolean
            Pcl_Max        => False, --Pcl_Max_Sw,       -- in     Boolean
            Electrical_Pwr => True, --Speedbrake_Cb,    -- in     Boolean
            Hyd_Fcn        => 1.0, --Hyd_Fcn,          -- in     Normalized_Hydraulic_Pressure_Type
            Dynamic_Px     => Dynamic_Pressure, -- in     Free_Air_Types.Pounds_per_Sq_Feet
            Switch_Extend  => Switch_Extend,    -- in     Boolean
            Switch_Retract => Switch_Retract);  -- in     Boolean

      elsif Ios_Pilot_Enable then

         if Ios_Pilot_Flaps > 0 then
            Ios.Ios_Pilot_Speed_Brake := 0;
         end if;

         if Ios_Pilot_Speed_Brake = 0 then
            Switch_Extend  := False;
            Switch_Retract := True;
         elsif Ios_Pilot_Speed_Brake = 1  then
            Switch_Extend  := True;
            Switch_Retract := False;
         end if;

         Speedbrake.Update
           (An_Instance    => The_Speedbrake,   -- in out Instance
            Iconst         => Iconst,           -- in     Float
            Flaps_Sel_Up   => True, --Flap_Sel_Up,      -- in     Boolean
            Pcl_Max        => False, --Pcl_Max_Sw,       -- in     Boolean
            Electrical_Pwr => True, --Speedbrake_Cb,    -- in     Boolean
            Hyd_Fcn        => 1.0, --Hyd_Fcn,          -- in     Normalized_Hydraulic_Pressure_Type
            Dynamic_Px     => Dynamic_Pressure, -- in     Free_Air_Types.Pounds_per_Sq_Feet
            Switch_Extend  => Switch_Extend,    -- in     Boolean
            Switch_Retract => Switch_Retract);  -- in     Boolean

      else

         Speedbrake.Update
           (An_Instance    => The_Speedbrake,   -- in out Instance
            Iconst         => Iconst,           -- in     Float
            Flaps_Sel_Up   => Flap_Sel_Up,      -- in     Boolean
            Pcl_Max        => Pcl_Max_Sw,       -- in     Boolean
            Electrical_Pwr => Speedbrake_Cb,    -- in     Boolean
            Hyd_Fcn        => Hyd_Fcn,          -- in     Normalized_Hydraulic_Pressure_Type
            Dynamic_Px     => Dynamic_Pressure, -- in     Free_Air_Types.Pounds_per_Sq_Feet
            Switch_Extend  => Switch_Extend,    -- in     Boolean
            Switch_Retract => Switch_Retract);  -- in     Boolean

      end if;


      --set speedbrake annunciator
      Io.Speed_Brake_Ann := ((Speedbrake.Position(The_Speedbrake)>0.0 and Ele.Is_Powered(Ele_T.Inst_Lts_Cb))
                             or
                             (Lights.Lamp_Test_Sw and Ele.Is_Powered(Ele_T.Test_Lts_Cb)));

      Ios.Speedbrake_Deployed := Speedbrake.Position (The_Speedbrake)>0.0;

      -- sound
      Sound.Speedbrake_Position := Speedbrake.Position (The_Speedbrake);

   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Speedbrake_Controller.Update()");
         raise;
   end Update;

end Jpats_Secondary_Flight_Controls.Speedbrake_Controller;

