-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  RUDDER TRIM
--  Rudder (yaw) trim is provided by an electromechanical
--  actuator located in the vertical stabilizer, which drives an
--  anti-servo tab surface on the trailing edge of the rudder. The
--  actuator is controlled by a switch installed on the PCL in
--  each cockpit. Tab deflection with the rudder at neutral is
--  limited to 6 trailing edge right and 11 trailing edge left.
--  Trim position is indicated on the trim control panel (Figure
--  1-26). Power is provided through a circuit breaker placarded
--  RUD TRIM, located on the battery bus circuit breaker panel
--  in the front cockpit.

--  TRIM AID DEVICE (TAD)
--  The rudder trim aid device (TAD) assists directional (yaw)
--  trimming during airspeed and power changes. The TAD
--  senses engine torque, altitude, airspeed, and pitch rate and
--  computes a desired rudder trim tab position. The computed
--  signal is applied to the rudder trim tab actuator, Which
--  deflects the trim tab to the computed position, resulting in
--  lower out of trim forces.
--  The trim aid device is selected by a magnetically locked
--  switch placarded TRIM AID, located on the left console in
--  the front cockpit (Figure 1-26). A green TAD OFF advisory
--  annunciator illuminates when the system is disengaged. An
--  amber TAD FAIL annunciator illuminates if the system has
--  failed internally. Actuating the trim interrupt button on the
--  control stick grip, or the TRIM DISCONNECT switch on
--  the trim control panel, will remove power from the rudder
--  tab actuator, including the reference voltage to the TAD,
--  causing the TAD to disengage, the TAD switch to move to
--  OFF, and the TAD OFF annunciator to illuminate. If the
--  TAD FAIL annunciator illuminates, the TAD system must
--  be reset by setting the TRIM AID switch to OFF, and then
--  back to ON. Power for the TAD is provided through a circuit
--  breaker placarded TAD, located on the generator bus
--  circuit breaker panel in the front cockpit.
--  Operation of the trim aid system is essentially transparent to
--  the pilot throughout the flight envelope. Manual yaw trim
--  input from the pilot is additive to the trim input that the TAD
--  commands. The TAD automatically sets takeoff trim in the
--  yaw axis when the trim aid system is switched on after
--  engine start. Once takeoff trim is set, the system will make
--  no further trim inputs until the aircraft accelerates to at Least
--  80 KIAS and there is no weight on the wheels. The trim aid
--  system will not completely trim the aircraft in yaw.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------

private package Jpats_Secondary_Flight_Controls.Rudder_Trim_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Secondary_Flight_Controls.Rudder_Trim_Controller;
