-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls.Container;
with Jpats_Avionics.Container;
with Jpats_Flight_Instruments.Container;

with Jpats_Electrical;
with Jpats_Auto_Test;
with Jpats_Simulated_Aircraft;
with Jpats_Aircraft_Body;
with Jpats_Atmosphere;
with Jpats_Powerplant;
with Jpats_Flight_Instruments;
with Jpats_Landing_Gear;

with Jpats_Secondary_Flight_Controls_Types;
with Jpats_Electrical_Types;
with Jpats_Landing_Gear_Types;
with JPATS_Aircraft_Body_Types;
with Rudder_Trim;
with Tad;
with Length_Types;
with Angle_Types;

with Ada.Numerics;
use Ada.Numerics;
with Ada.Numerics.Elementary_Functions; use Ada.Numerics.Elementary_Functions;
with Log;

package body Jpats_Secondary_Flight_Controls.Rudder_Trim_Controller is

   procedure Initialize
   is
      package Ctnr renames Container;
   begin
      Rudder_Trim.Initialize(Ctnr.This_Subsystem.The_Rudder_Trim);
      Tad.Initialize(Ctnr.This_Subsystem.The_Tad);

      Tad.Read_Tables;

   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Rudder_Trim_Controller.Initialize()");
         raise;
   end Initialize;

   Ind_Pwr_Off_Angle : Float renames Container.This_Subsystem.RTC_Ind_Pwr_Off_Angle;
   Ind_Pwr_Up_Angle  : Float renames Container.This_Subsystem.RTC_Ind_Pwr_Up_Angle;

   procedure Update
     (Iconst : in Float)
   is

      package Ctnr    renames Container;
      package Ele     renames Jpats_Electrical;
      package Ele_T   renames Jpats_Electrical_Types;
      package Sim_Air renames Jpats_Simulated_Aircraft;
      package Flt_Int renames Jpats_Flight_Instruments;
      package Sfc_T   renames Jpats_Secondary_Flight_Controls_Types;
      package Gear    renames Jpats_Landing_Gear;
      package Gear_T  renames Jpats_Landing_Gear_Types;

      The_Rudder_Trim : Rudder_Trim.Instance renames Ctnr.This_Subsystem.The_Rudder_Trim;

      The_Tad : Tad.Instance renames Ctnr.This_Subsystem.The_Tad;

      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
      Jac : Jpats_Avionics.Container.Ios_Interface_Instance renames
               Jpats_Avionics.Container.This_Ios_Interface;
      Jfc : Jpats_Flight_Instruments.Container.Ios_Interface_Instance renames
               Jpats_Flight_Instruments.Container.This_Ios_Interface;

      Rudder_Trim_Switch_Left  : Boolean  := Io.Rudder_Trim_Sw_Left;
      Rudder_Trim_Switch_Right : Boolean  := Io.Rudder_Trim_Sw_Right;
      Trim_Disconnect          : Boolean  := Io.Trim_Disconnect_Sw;
      Trim_Interrupt           : Boolean  := Io.Trim_Interrupt_Sw;
      Tad_On_Switch            : Boolean  := True;
      Tad_On                   : Boolean  := True;
      Tad_Av_Input_Fault       : Boolean  := Jac.Ahrs_Fail_Malf or Jfc.Adc_Fail;

      Tad_Cb       : constant Boolean := Ele.Is_Powered (Ele_T.Tad_Cb);
      Rud_Trim_Cb  : constant Boolean := Ele.Is_Powered (Ele_T.Rud_Trim_Cb);
      Kias_Adc     : constant Length_Types.Knots := Flt_Int.Primary_Ias;
      Pitch_Rate   : constant Angle_Types.Radians_per_Sec := Sim_Air.Get_Pitch_Rate;
      Trim_Ind_Cb  : constant Boolean := Ele.Is_Powered (Ele_T.Trim_Ind_Cb);

      Pressure_Altitude : constant length_types.Feet := Flt_Int.Primary_Alt;
      Engine_Torque     : constant Float := Jpats_Powerplant.Engine_Torque_Pct;

      Rudder_Trim_Actuated_Position : constant Sfc_T.Rudder_Trim_Position_Type := Rudder_Trim.Actuated_Position (The_Rudder_Trim);
      Left_Wow  : constant Boolean := Gear.Is_Closed (Gear_T.Left_Landing_Gear_A1_WOW_Relay);
      Right_Wow : constant Boolean := Gear.Is_Closed (Gear_T.Right_Landing_Gear_A1_WOW_Relay);

      Rud_Tab_Mode : constant Integer := Jpats_Auto_Test.Rud_Tab_Mode; -- 0,1,2,3 per notes
      Rud_Tab_Pos : constant Float := Jpats_Auto_Test.Rud_Tab_Pos;
      Auto_Test_Selected : constant Boolean := Rud_Tab_Mode /= 0;
      Auto_Test_Position_Demanded : constant Sfc_T.Rudder_Trim_Position_Type :=
        Sfc_T.Rudder_Trim_Position_Type (Rud_Tab_Pos);

      Rudder_Trim_Position : constant Sfc_T.Rudder_Trim_Position_Type := Rudder_Trim.Position(The_Rudder_Trim);
      Rudder_Position : constant Float := Float(Jpats_Aircraft_Body.Get_Rudder_Position);

      Angle_To_Ind : Float := 0.0;
      Rud_Trim_Act_Pos : Float := 0.0;

      Auto_Test_Tad_Sw_On : Boolean := False;
      Both_Angles_In_Same_Quadrant : Boolean; -- bad name
      Temp   : Float := 0.0;

   begin
      Tad_On_Switch := Io.Trim_Aid_On_Sw and Ele.Is_Powered (Ele_T.Adc_Cb);
      if Rud_Tab_Mode > 0 then
         if Rud_Tab_Mode = 1 or Rud_Tab_Mode = 3 then
            Tad_On_Switch := False;
            if Rud_Tab_Mode = 3 then
                Temp := Auto_Test_Position_Demanded + 0.2 * Rudder_Position;
                Rudder_Trim.Set_Position
                (An_Instance  => The_Rudder_Trim,
                 Tab_Position => Temp,
                 Rudder_Angle => Rudder_Position);
            end if;
         end if;
         if Rud_Tab_Mode = 1 or Rud_Tab_Mode = 2 then
             Tad_On_Switch := Rud_Tab_Mode = 2;
             if Auto_Test_Position_Demanded = 1.0 then --< Rudder_Trim_Position then
               Rudder_Trim_Switch_Left  := False;
               Rudder_Trim_Switch_Right := True;
            elsif Auto_Test_Position_Demanded = -1.0 then --> Rudder_Trim_Position then
               Rudder_Trim_Switch_Left  := True;
               Rudder_Trim_Switch_Right := False;
            else
               Rudder_Trim_Switch_Left  := False;
               Rudder_Trim_Switch_Right := False;
            end if;
         end if;
      end if;

      if not (Rud_Tab_Mode = 3) then
         Tad.update
           (An_Instance                   => The_Tad,                        -- in out Instance
            Iconst                        => Iconst,                         -- in     Float
            Left_Wow_Relay                => Left_Wow,                       -- in     Boolean
            Right_Wow_Relay               => Right_Wow,                      -- in     Boolean
            Tad_Cb                        => Tad_Cb,                         -- in     BooleanRudder_Position
            Kias_Adc                      => Kias_Adc,                       -- in     Length_Types.Knots
            Pitch_Rate                    => Pitch_Rate,                     -- in     Angle_Types.Radians_per_Sec
            Pressure_Altitude             => Pressure_Altitude,              -- in     length_types.Feet
            Engine_Torque                 => Engine_Torque,                  -- in     Float
            Rudder_Trim_Actuated_Position => Rudder_Trim_Actuated_Position,  -- in     Rudder_Trim_Position_Type
            Trim_Disconnect               => Trim_Disconnect,                -- in     Boolean
            Trim_Interrupt                => Trim_Interrupt,                 -- in     Boolean
            Tad_Fault                     => Tad_Av_Input_Fault,             -- in     Boolean
            Rudder_Trim_Switch_Left       => Rudder_Trim_Switch_Left,        -- in     Boolean
            Rudder_Trim_Switch_Right      => Rudder_Trim_Switch_Right,       -- in     Boolean
            Tad_On_Switch                 => Tad_On_Switch);                 -- in     Boolean

         Rudder_Trim.Update
           (An_Instance              => The_Rudder_Trim,           -- in out Instance
            Iconst                   => Iconst,                    -- in     Float
            Rud_Trim_Cb              => Rud_Trim_Cb,               -- in     Boolean
            Tad_On                   => Tad.Tad_On (The_Tad),      -- in     Boolean
            Trim_Interrupt           => Trim_Interrupt,            -- in     Boolean
            Trim_Disconnect          => Trim_Disconnect,           -- in     Boolean
            Tad_Command              => Tad.Tad_Command (The_Tad), -- in     Float
            Rudder_Trim_Switch_Left  => Rudder_Trim_Switch_Left,   -- in     Boolean
            Rudder_Trim_Switch_Right => Rudder_Trim_Switch_Right,  -- in     Boolean
            Rudder_Angle             => Rudder_Position,          -- in     Float
            Trim_Fail_Malf           => Ios.Rudder_Trim_Fail_Malf,  --: in     Boolean;
            Full_Right_Malf          => Ios.Rudder_Trim_Full_Right_Malf); --: in     Boolean);
      else
         null;
      end if;

      Io.Lh_Sw_Cont_Trim_Aid_Sw := Tad.Tad_On(The_Tad);


      -- drive rudder trim display

      Rud_Trim_Act_Pos := Rudder_Trim.Actuated_Position(The_Rudder_Trim);

      if Rud_Trim_Act_Pos <= 0.0 then
         Angle_To_Ind := 8.0 * Rud_Trim_Act_Pos + 360.0;
         if Angle_To_Ind < 312.0 then Angle_To_Ind := 312.0; end if;
         if Angle_To_Ind > 360.0 then Angle_To_Ind := 360.0; end if;
      else
         Angle_To_Ind := (90.0/11.0) * Rud_Trim_Act_Pos;
         if Angle_To_Ind < 0.0  then Angle_To_Ind := 0.0; end if;
         if Angle_To_Ind > 90.0 then Angle_To_Ind := 90.0; end if;
      end if;

--       if Rud_Trim_Act_Pos <= -0.08695652173 then
--          Angle_To_Ind := 8.11764705881 * (9.741176/8.11764705881) * Rud_Trim_Act_Pos + 360.705882353;
--          if Angle_To_Ind < 312.0 then Angle_To_Ind := 312.0; end if;
--          if Angle_To_Ind > 360.0 then Angle_To_Ind := 360.0; end if;
--       else
--          Angle_To_Ind := 8.11764705885 * (10.0/8.11764705885) * Rud_Trim_Act_Pos + 0.7058823526;
--          if Angle_To_Ind < 0.0  then Angle_To_Ind := 0.0; end if;
--          if Angle_To_Ind > 90.0 then Angle_To_Ind := 90.0; end if;
--       end if;


      Ios.Rudder_Trim_Angle := Angle_To_Ind;
      Ios.Rudder_Trim_Deflection_Angle := Rud_Trim_Act_Pos;

      if Trim_Ind_Cb then

         Both_Angles_In_Same_Quadrant := ((Angle_To_Ind <= 90.0 and Ind_Pwr_Up_Angle <= 90.0)
                                          or
                                          (Angle_To_Ind > 90.0 and Ind_Pwr_Up_Angle > 90.0));

         if abs(Angle_To_Ind - Ind_Pwr_Up_Angle) <= (10.0*Iconst) then
            Ind_Pwr_Up_Angle := Angle_To_Ind;
         elsif Both_Angles_In_Same_Quadrant then
            if Angle_To_Ind - Ind_Pwr_Up_Angle > 0.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle + 10.0*Iconst;
            elsif Angle_To_Ind - Ind_Pwr_Up_Angle < 0.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle - 10.0*Iconst;
            end if;
         else
            if Angle_To_Ind <= 90.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle + 10.0*Iconst;
               if Ind_Pwr_Up_Angle > 360.0 then Ind_Pwr_Up_Angle := 0.0; end if;
            elsif Ind_Pwr_Up_Angle <= 90.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle - 10.0*Iconst;
               if Ind_Pwr_Up_Angle < 0.0 then Ind_Pwr_Up_Angle := 360.0; end if;
            end if;
         end if;

--          elsif Angle_To_Ind - Ind_Pwr_Up_Angle > 0.0 and Both_Angles_In_Same_Quadrant then
--             Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle + 10.0*Iconst;
--             if Ind_Pwr_Up_Angle > 360.0 then Ind_Pwr_Up_Angle := 0.0; end if;
--          elsif Angle_To_Ind - Ind_Pwr_Up_Angle < 0.0 and Both_Angles_In_Same_Quadrant then
--             Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle - 10.0*Iconst;
--             if Ind_Pwr_Up_Angle < 0.0 then Ind_Pwr_Up_Angle := 360.0; end if;
--          end if;



--          Io.Trim_Pos_Chan_2_Sine   := 10.0*Sin(Angle_To_Ind,360.0);
--          Io.Trim_Pos_Chan_2_Cosine := 10.0*Cos(Angle_To_Ind,360.0);
         Io.Trim_Pos_Chan_2_Sine   := 10.0*Sin(Ind_Pwr_Up_Angle,360.0);
         Io.Trim_Pos_Chan_2_Cosine := 10.0*Cos(Ind_Pwr_Up_Angle,360.0);
--         Ind_Pwr_Off_Angle := Angle_To_Ind;
         Ind_Pwr_Off_Angle := Ind_Pwr_Up_Angle;

      else

         if Ind_Pwr_Off_Angle < 0.0 then Ind_Pwr_Off_Angle := 360.0; end if;
         Ind_Pwr_Off_Angle := Ind_Pwr_Off_Angle - 10.0*Iconst;
         if Ind_Pwr_Off_Angle < 272.5 and Ind_Pwr_Off_Angle > 90.0 then Ind_Pwr_Off_Angle := 272.5; end if;
         Io.Trim_Pos_Chan_2_Sine   := 10.0*Sin(Ind_Pwr_Off_Angle,360.0);
         Io.Trim_Pos_Chan_2_Cosine := 10.0*Cos(Ind_Pwr_Off_Angle,360.0);
         Ind_Pwr_Up_Angle := Ind_Pwr_Off_Angle;

      end if;

   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Rudder_Trim_Controller.Update()");
         raise;
   end Update;

end Jpats_Secondary_Flight_Controls.Rudder_Trim_Controller;


