-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls.Container;
with Jpats_Ios_Interface;
with Log;

package body Jpats_Secondary_Flight_Controls.Ios_Interface is

   package Ctnr renames Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   Io  : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   package JII renames Jpats_Ios_Interface;

   procedure Aileron_Trim_Fail_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aileron_Trim_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Aileron_Trim_Fail_Malf_Cmd()");
         raise;
   end Aileron_Trim_Fail_Malf_Cmd;

   procedure Rudder_Trim_Fail_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Rudder_Trim_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Rudder_Trim_Fail_Malf_Cmd()");
         raise;
   end Rudder_Trim_Fail_Malf_Cmd;

   procedure Elevator_Trim_Full_Down_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Elevator_Trim_Full_Down_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Elevator_Trim_Full_Down_Malf_Cmd()");
         raise;
   end Elevator_Trim_Full_Down_Malf_Cmd;

   procedure Elevator_Trim_Fail_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Elevator_Trim_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Elevator_Trim_Fail_Malf_Cmd()");
         raise;
   end Elevator_Trim_Fail_Malf_Cmd;

   procedure Aileron_Trim_Full_Roll_Right_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Aileron_Trim_Full_Roll_Right_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Aileron_Trim_Full_Roll_Right_Malf_Cmd()");
         raise;
   end Aileron_Trim_Full_Roll_Right_Malf_Cmd;

   procedure Rudder_Trim_Full_Right_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Rudder_Trim_Full_Right_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Rudder_Trim_Full_Right_Malf_Cmd()");
         raise;
   end Rudder_Trim_Full_Right_Malf_Cmd;

   procedure Left_Outboard_Flap_Fail_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Left_Outboard_Flap_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Left_Outboard_Flap_Fail_Malf_Cmd()");
         raise;
   end Left_Outboard_Flap_Fail_Malf_Cmd;

   procedure Right_Outboard_Flap_Fail_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Right_Outboard_Flap_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Right_Outboard_Flap_Fail_Malf_Cmd()");
         raise;
   end Right_Outboard_Flap_Fail_Malf_Cmd;

   procedure Left_Side_Flaps_Fail_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Left_Side_Flaps_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Left_Side_Flaps_Fail_Malf_Cmd()");
         raise;
   end Left_Side_Flaps_Fail_Malf_Cmd;

   procedure Right_Side_Flaps_Fail_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Right_Side_Flaps_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Right_Side_Flaps_Fail_Malf_Cmd()");
         raise;
   end Right_Side_Flaps_Fail_Malf_Cmd;

   procedure Flaps_Frozen_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Flaps_Frozen_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Flaps_Frozen_Malf_Cmd()");
         raise;
   end Flaps_Frozen_Malf_Cmd;

   procedure Flap_Indicator_Fail_Malf_Cmd
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Flap_Indicator_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Flap_Indicator_Fail_Malf_Cmd()");
         raise;
   end Flap_Indicator_Fail_Malf_Cmd;


   procedure Ios_Pilot_Flaps_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ios_Pilot_Flaps := JII.Convert_To_Integer(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Ios_Pilot_Flaps_Command()");
         raise;
   end Ios_Pilot_Flaps_Command;


   procedure Ios_Pilot_Speed_Brake_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ios_Pilot_Speed_Brake := JII.Convert_To_Integer(PData);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Ios_Pilot_Speed_Brake_Command()");
         raise;
   end Ios_Pilot_Speed_Brake_Command;


--     procedure Ios_Pilot_Enable_Command
--       (PData : JPATS_IOS_Interface.Set_Value)
--     is
--     begin
--        Ios.Ios_Pilot_Enable := JII.Convert_To_Bool(PData);
--     exception
--        when others =>
--           Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Ios_Pilot_Enable_Command");
--           raise;
--     end Ios_Pilot_Enable_Command;


   procedure Register_Ios_Variables
   is
   begin

      JPATS_IOS_Interface.Register
        (Name        => "Elevator_Trim_Angle",
         Variable    => Ios.Elevator_Trim_Angle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Aileron_Trim_Angle",
         Variable    => Ios.Aileron_Trim_Angle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Rudder_Trim_Angle",
         Variable    => Ios.Rudder_Trim_Angle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Flap_Handle_Position",
         Variable    => Ios.Flap_Handle_Position'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Flap_Position",
         Variable    => Io.Flap_Position'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Elevator_Trim_Full_Down_Malf",
         Variable    => Ios.Elevator_Trim_Full_Down_Malf'Address,
         Set_Routine => Elevator_Trim_Full_Down_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Elevator_Trim_Fail_Malf",
         Variable    => Ios.Elevator_Trim_Fail_Malf'Address,
         Set_Routine => Elevator_Trim_Fail_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Aileron_Trim_Full_Roll_Right_Malf",
         Variable    => Ios.Aileron_Trim_Full_Roll_Right_Malf'Address,
         Set_Routine => Aileron_Trim_Full_Roll_Right_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Rudder_Trim_Full_Right_Malf",
         Variable    => Ios.Rudder_Trim_Full_Right_Malf'Address,
         Set_Routine => Rudder_Trim_Full_Right_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Left_Outboard_Flap_Fail_Malf",
         Variable    => Ios.Left_Outboard_Flap_Fail_Malf'Address,
         Set_Routine => Left_Outboard_Flap_Fail_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Right_Outboard_Flap_Fail_Malf",
         Variable    => Ios.Right_Outboard_Flap_Fail_Malf'Address,
         Set_Routine => Right_Outboard_Flap_Fail_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Left_Side_Flaps_Fail_Malf",
         Variable    => Ios.Left_Side_Flaps_Fail_Malf'Address,
         Set_Routine => Left_Side_Flaps_Fail_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Right_Side_Flaps_Fail_Malf",
         Variable    => Ios.Right_Side_Flaps_Fail_Malf'Address,
         Set_Routine => Right_Side_Flaps_Fail_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Flaps_Frozen_Malf",
         Variable    => Ios.Flaps_Frozen_Malf'Address,
         Set_Routine => Flaps_Frozen_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ios_Pilot_Flaps",
         Variable    => Ios.Ios_Pilot_Flaps'Address,
         Set_Routine => Ios_Pilot_Flaps_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ios_Pilot_Speed_Brake",
         Variable    => Ios.Ios_Pilot_Speed_Brake'Address,
         Set_Routine => Ios_Pilot_Speed_Brake_Command'Access
         );

--        JPATS_IOS_Interface.Register
--          (Name        => "Ios_Pilot_Enable",
--           Variable    => Ios.Ios_Pilot_Enable'Address,
--           Set_Routine => Ios_Pilot_Enable_Command'Access
--           );

      JPATS_IOS_Interface.Register
        (Name        => "Flap_Indicator_Fail_Malf",
         Variable    => Ios.Flap_Indicator_Fail_Malf'Address,
         Set_Routine => Flap_Indicator_Fail_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Speed_Brake_Ann",
         Variable    => Io.Speed_Brake_Ann'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Elevator_Trim_Deflection_Angle",
         Variable    => Ios.Elevator_Trim_Deflection_Angle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Aileron_Trim_Deflection_Angle",
         Variable    => Ios.Aileron_Trim_Deflection_Angle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Rudder_Trim_Deflection_Angle",
         Variable    => Ios.Rudder_Trim_Deflection_Angle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Speedbrake_Deployed",
         Variable    => Ios.Speedbrake_Deployed'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Trim_Aid_On_Sw",
         Variable    => Io.Trim_Aid_On_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Trim_Disconnect_Sw",
         Variable    => Io.Trim_Disconnect_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Aileron_Trim_Fail_Malf",
         Variable    => Ios.Aileron_Trim_Fail_Malf'Address,
         Set_Routine => Aileron_Trim_Fail_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Rudder_Trim_Fail_Malf",
         Variable    => Ios.Rudder_Trim_Fail_Malf'Address,
         Set_Routine => Rudder_Trim_Fail_Malf_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Trim_Interrupt_Sw",
         Variable    => Io.Trim_Interrupt_Sw'Address
         );

   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;


end Jpats_Secondary_Flight_Controls.Ios_Interface;
