-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls.Container;
with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;
with Log;

package body Jpats_Secondary_Flight_Controls.Io_Interface is

   package JIOT renames Jpats_Io_Types;
   Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;

   procedure Register_Io_Variables
   is
   begin

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TRIM_AID_ON_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Trim_Aid_On_Sw'Address,
         A_Size          => Io.Trim_Aid_On_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TRIM_DISCONNECT_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Trim_Disconnect_Sw'Address,
         A_Size          => Io.Trim_Disconnect_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "RUDDER_TRIM_SW_LEFT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Rudder_Trim_Sw_Left'Address,
         A_Size          => Io.Rudder_Trim_Sw_Left'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "RUDDER_TRIM_SW_RIGHT",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Rudder_Trim_Sw_Right'Address,
         A_Size          => Io.Rudder_Trim_Sw_Right'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "SPEED_BRAKE_RETRACT_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Speed_Brake_Retract_Sw'Address,
         A_Size          => Io.Speed_Brake_Retract_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "SPEED_BRAKE_EXTEND_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Speed_Brake_Extend_Sw'Address,
         A_Size          => Io.Speed_Brake_Extend_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "FLAP_CONT_TO_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Flap_Cont_To_Sw'Address,
         A_Size          => Io.Flap_Cont_To_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "flap_cont_up_sw",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Flap_Cont_Up_Sw'Address,
         A_Size          => Io.Flap_Cont_Up_Sw'Size);

--       Jpats_Io.Map_To_Icd_mnemonic
--         (An_Interface    => JIOT.Flight_Deck,
--          An_Icd_Mnemonic => "SPEED_BRAKE_MAX_PWR_SW",
--          A_Direction     => IO_Types.Input,
--          An_Address      => Io.Speed_Brake_Max_Pwr_Sw'Address,
--          A_Size          => Io.Speed_Brake_Max_Pwr_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "AILERON_ELEV_TRIM_DN_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aileron_Elev_Trim_Dn_Sw'Address,
         A_Size          => Io.Aileron_Elev_Trim_Dn_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "AILERON_ELEV_TRIM_LEFT_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aileron_Elev_Trim_Left_Sw'Address,
         A_Size          => Io.Aileron_Elev_Trim_Left_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "AILERON_ELEV_TRIM_UP_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aileron_Elev_Trim_Up_Sw'Address,
         A_Size          => Io.Aileron_Elev_Trim_Up_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "AILERON_ELEV_TRIM_RIGHT_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Aileron_Elev_Trim_Right_Sw'Address,
         A_Size          => Io.Aileron_Elev_Trim_Right_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TRIM_INTERRUPT_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Trim_Interrupt_Sw'Address,
         A_Size          => Io.Trim_Interrupt_Sw'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "SPEED_BRAKE_ANN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Speed_Brake_Ann'Address,
         A_Size          => Io.Speed_Brake_Ann'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "LH_SW_CONT_TRIM_AID_SW",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Lh_Sw_Cont_Trim_Aid_Sw'Address,
         A_Size          => Io.Lh_Sw_Cont_Trim_Aid_Sw'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "FLAP_POSITION",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Flap_Position'Address,
         A_Size          => Io.Flap_Position'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TRIM_POS_CHAN_1_SINE",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Trim_Pos_Chan_1_Sine'Address,
         A_Size          => Io.Trim_Pos_Chan_1_Sine'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TRIM_POS_CHAN_1_COSINE",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Trim_Pos_Chan_1_Cosine'Address,
         A_Size          => Io.Trim_Pos_Chan_1_Cosine'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TRIM_POS_CHAN_2_SINE",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Trim_Pos_Chan_2_Sine'Address,
         A_Size          => Io.Trim_Pos_Chan_2_Sine'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TRIM_POS_CHAN_2_COSINE",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Trim_Pos_Chan_2_Cosine'Address,
         A_Size          => Io.Trim_Pos_Chan_2_Cosine'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TRIM_POS_CHAN_3_SINE",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Trim_Pos_Chan_3_Sine'Address,
         A_Size          => Io.Trim_Pos_Chan_3_Sine'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "TRIM_POS_CHAN_3_COSINE",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Trim_Pos_Chan_3_Cosine'Address,
         A_Size          => Io.Trim_Pos_Chan_3_Cosine'Size);


   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Io_Interface.Register_Io_Variables()");
         raise;
   end Register_Io_Variables;

end Jpats_Secondary_Flight_Controls.Io_Interface;

