-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  WING FLAPS
--  The aircraft is equipped with hydraulically operated, electrically
--  controlled, four-segment split flaps, with a normal system
--  for extension and retraction, and an emergency system
--  for extending the flaps and landing gear. The system
--  includes two flap selectors, two selector valves for normal
--  operation, an emergency extension selector valve, a flap
--  actuator, a flap torque tube, two flap position indicators
--  (Figure 1-22) and associated microswitches.
--  NOTE
--  Physical position of the flaps cannot be
--  determined or verified from either cockpit
--  because the flaps are hinged to the lower surface
--  of the wing.

--  EXTENSION/RETRACTION
--  The flap control system operates the flaps through a centrally
--  located hydraulic actuator. Flap position is controlled
--  by a three-position flap selector, placarded UP, TO (takeoff,
--  23 deflection), and LDG (landing, 50 deflection), located
--  in the left console in each cockpit (Figure 1-11). The selectors
--  are interconnected so that operation of one selector is
--  duplicated by the other. Electrical power for the flap system
--  is provided through a circuit breaker placarded FLAP
--  CONT, located on the battery bus circuit breaker panel in
--  the front cockpit.
--  During normal operation, the flap selector controls the
--  hydraulic flap actuator, which is connected to the flap
--  torque tube. When hydraulic power is applied to the actuator,
--  the actuator rotates the torque tube and flap segments to
--  the selected setting.
--  As the torque tube rotates, a cam on the torque tube activates
--  position sensing microswitches to drive the flap indicator
--  in each cockpit. In the event of an indicator failure, the
--  flap handle serves as a secondary position indicator.
--  NOTE
--  Normal and emergency flap operation and
--  indication are unavailable anytime the battery
--  bus has failed or when the auxiliary battery
--  is the only source of electrical power.

--  EMERGENCY EXTENSION
--  Emergency flap extension is enabled after the emergency
--  landing gear extension handle is operated and the landing
--  gear have been extended. Following landing gear extension,
--  either flap selector will control emergency flap extension to
--  the LDG position. The emergency selector valve is solenoid
--  operated and is located in the hydraulic power system emergency
--  pack. The flaps cannot be retracted after emergency
--  extension until the aircraft is serviced by maintenance.

--  FLAP INDICATOR
--  A flap indicator (Figure 1-22) is located above the landing
--  gear control handle on the lower left side of the instrument
--  panel in each cockpit. The flap position is indicated by a
--  pointer which points at one of three placarded stops. The
--  stops match the flap lever markings of UP, TO (takeoff), and
--  LDG (landing). During deployment or retraction, the position
--  pointer moves to an intermediate position between the
--  placarded settings to indicate flap motion. When power is
--  removed from the flap indicator (e.g. battery switch OFF or
--  battery failure), the position pointer moves to a position
--  counterclockwise of the UP position.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------
private package Jpats_Secondary_Flight_Controls.Flaps_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Secondary_Flight_Controls.Flaps_Controller;
