-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls.Container;
with Jpats_Electrical;
with Jpats_Hydraulics;
with Jpats_Auto_Test;
with Jpats_Simulated_Aircraft;
with Jpats_Landing_Gear;
with Jpats_Electrical_Types;
with Jpats_Secondary_Flight_Controls_Types;
with Jpats_Hydraulics_Types;
with Jpats_Landing_Gear_Types;
with Force_Types;
with Aircraft_Flaps;
with Log;
with Jpats_IOS_Pilot;

package body Jpats_Secondary_Flight_Controls.Flaps_Controller is

   procedure Initialize is
   begin
      Aircraft_Flaps.Initialize (Jpats_Secondary_Flight_Controls.Container.This_Subsystem.The_Flaps);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Flaps_Controller.Initialize()");
         raise;
   end Initialize;

   Flap_Ind_Timer_1 : Float renames Container.This_Subsystem.FC_Flap_Ind_Timer_1;
   Flap_Ind_Timer_2 : Float renames Container.This_Subsystem.FC_Flap_Ind_Timer_2;
   Flap_Ind_Timer_3 : Float renames Container.This_Subsystem.FC_Flap_Ind_Timer_3;

   Gauge_Flap_Position : Float renames Container.This_Subsystem.FC_Gauge_Flap_Position;
   Gauge_Flap_Position_Last_Pass : Float renames Container.This_Subsystem.FC_Gauge_Flap_Position_Last_Pass;

   Extending  : Boolean renames Container.This_Subsystem.FC_Extending;
   Retracting : Boolean renames Container.This_Subsystem.FC_Retracting;
   Freeze_Ind : Boolean renames Container.This_Subsystem.FC_Freeze_Ind;

   procedure Update
     (Iconst : in Float) is

      package Ctnr      renames Container;
      package Ele       renames Jpats_Electrical;
      package Ele_T     renames Jpats_Electrical_Types;
      package Sfc       renames Jpats_Secondary_Flight_Controls;
      package Sfc_T     renames Jpats_Secondary_Flight_Controls_Types;
      package Auto_Test renames Jpats_Auto_Test;
      package Hyd       renames Jpats_Hydraulics;
      package Hyd_T     renames Jpats_Hydraulics_Types;
      package Gear      renames Jpats_Landing_Gear;
      package Gear_T    renames Jpats_Landing_Gear_Types;
      package Sac       renames Jpats_Simulated_Aircraft;
      package Jip       renames Jpats_IOS_Pilot;

      Auto_Test_Selected          : constant Boolean := Jpats_Auto_Test.On;
      Auto_Test_Position_Demanded : constant Sfc_T.Flap_Position_Type := Sfc_T.Flap_Position_Type(Auto_Test.Flap_Pos);
      Flap_Control_Cb             : constant Boolean := Ele.Is_Powered (Ele_T.Flap_Cont_Cb);

      The_Flaps : Aircraft_Flaps.Instance renames Container.This_Subsystem.The_Flaps;

      Io  : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
      Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;


      Flap_Selector_Take_Off : Boolean := Io.Flap_Cont_To_Sw;
      Flap_Selector_Up       : Boolean := Io.Flap_Cont_Up_Sw;
      Flap_Selector_Land     : Boolean := not Flap_Selector_Take_Off and not Flap_Selector_Up;


      Hyd_Fcn       : Hyd_T.Normalized_Pressure_Type := Hyd.Primary_System_Pressure_Function;
      Emerg_Hyd_Fcn : constant Hyd_T.Normalized_Pressure_Type := Hyd.Emergency_System_Pressure_Function;

      Emerg_Gear_Handle_Extend : constant Boolean := Gear.Emergency_Gear_Handle_Extended;

      Mean_Gear_Position : constant Gear_T.Gear_Position_Type := Gear.Mean_Gear_Position;

      Dynamic_Pressure : constant Force_Types.Pounds_Per_Sq_Feet := Sac.Get_Dynamic_Pressure;

      Flaps_Deflection : constant Sfc_T.Flap_Position_Type := Aircraft_Flaps.Deflection(The_Flaps);

      Auto_Test_Emer_Gear : constant Boolean := Auto_Test.Emer_Gear;

      Ios_Pilot_Enable : constant Boolean := Jip.Ios_Pilot_Enable;
      Ios_Pilot_Flaps  : constant Integer := Ios.Ios_Pilot_Flaps;

   begin

      if Auto_Test_Selected then
         if Auto_Test_Position_Demanded = 0.0 then
            Flap_Selector_Up       := True;
            Flap_Selector_Take_Off := False;
            Flap_Selector_Land     := False;
         elsif Auto_Test_Position_Demanded = 23.0 then
            Flap_Selector_Up       := False;
            Flap_Selector_Take_Off := True;
            Flap_Selector_Land     := False;
         elsif Auto_Test_Position_Demanded = 50.0 then
            Flap_Selector_Up       := False;
            Flap_Selector_Take_Off := False;
            Flap_Selector_Land     := True;
         end if;
         Aircraft_Flaps.Update
           (An_Instance              => The_Flaps,               --in out Instance
            Iconst                   => Iconst,                  --in     Float
            Emerg_Gear_Handle_Extend => Auto_Test_Emer_Gear,     --Emerg_Gear_Handle_Extend, --in     Boolean
            Primary_Hyd_Fcn          => 1.0,                     --hyd_fcn,  --in     Normalized_Hydraulic_Pressure_Type
            Emerg_Hyd_Fcn            => 1.0,                     --emerg_hyd_fcn,  --in     Normalized_Hydraulic_Pressure_Type
            Flap_Selector_Up         => Flap_Selector_Up,        --in     Boolean
            Flap_Selector_Take_Off   => Flap_Selector_Take_Off,  --in     Boolean
            Flap_Selector_Land       => Flap_Selector_Land,      --in     Boolean
            Flap_Cont_Cb             => True,                    --Flap_Control_Cb,   --in     Boolean
            Mean_Gear_Position       => Mean_Gear_Position,      --in     Jpats_Landing_Gear_Types.Gear_Position_Type
            Dynamic_Pressure         => Dynamic_Pressure,        --in     Free_Air_Types.Pounds_Per_Sq_Feet
            Fail_Left_Outboard_Flap  => False,                               --Ios.Left_Outboard_Flap_Fail_Demanded,    --in     Boolean
            Fail_Right_Outboard_Flap => False,                               --Ios.Right_Outboard_Flap_Fail_Demanded,   --in     Boolean
            Fail_Left_Wing_Flaps     => False,                               --Ios.Left_Side_Flaps_Fail_Demanded,       --in     Boolean
            Fail_Right_Wing_Flaps    => False,                               --Ios.Right_Side_Flaps_Fail_Demanded);     --in     Boolean
            Fail_All_Malf            => False);                              --: in     Boolean);

      elsif Ios_Pilot_Enable then
         if Ios_Pilot_Flaps = 0 then
            Flap_Selector_Up       := True;
            Flap_Selector_Take_Off := False;
            Flap_Selector_Land     := False;
         elsif Ios_Pilot_Flaps = 1 then
            Flap_Selector_Up       := False;
            Flap_Selector_Take_Off := True;
            Flap_Selector_Land     := False;
         elsif Ios_Pilot_Flaps = 2 then
            Flap_Selector_Up       := False;
            Flap_Selector_Take_Off := False;
            Flap_Selector_Land     := True;
         end if;
         Aircraft_Flaps.Update
           (An_Instance              => The_Flaps,               --in out Instance
            Iconst                   => Iconst,                  --in     Float
            Emerg_Gear_Handle_Extend => Emerg_Gear_Handle_Extend,--in     Boolean
            Primary_Hyd_Fcn          => Hyd_Fcn,                 --in     Normalized_Hydraulic_Pressure_Type
            Emerg_Hyd_Fcn            => Emerg_Hyd_Fcn,           --in     Normalized_Hydraulic_Pressure_Type
            Flap_Selector_Up         => Flap_Selector_Up,        --in     Boolean
            Flap_Selector_Take_Off   => Flap_Selector_Take_Off,  --in     Boolean
            Flap_Selector_Land       => Flap_Selector_Land,      --in     Boolean
            Flap_Cont_Cb             => Flap_Control_Cb,         --in     Boolean
            Mean_Gear_Position       => Mean_Gear_Position,      --in     Jpats_Landing_Gear_Types.Gear_Position_Type
            Dynamic_Pressure         => Dynamic_Pressure,        --in     Free_Air_Types.Pounds_Per_Sq_Feet
            Fail_Left_Outboard_Flap  => Ios.Left_Outboard_Flap_Fail_Malf,    --in     Boolean
            Fail_Right_Outboard_Flap => Ios.Right_Outboard_Flap_Fail_Malf,   --in     Boolean
            Fail_Left_Wing_Flaps     => Ios.Left_Side_Flaps_Fail_Malf,       --in     Boolean
            Fail_Right_Wing_Flaps    => Ios.Right_Side_Flaps_Fail_Malf,      --in     Boolean
            Fail_All_Malf            => Ios.Flaps_Frozen_Malf);              --: in     Boolean);

      else
         Aircraft_Flaps.Update
           (An_Instance              => The_Flaps,               --in out Instance
            Iconst                   => Iconst,                  --in     Float
            Emerg_Gear_Handle_Extend => Emerg_Gear_Handle_Extend,--in     Boolean
            Primary_Hyd_Fcn          => Hyd_Fcn,                 --in     Normalized_Hydraulic_Pressure_Type
            Emerg_Hyd_Fcn            => Emerg_Hyd_Fcn,           --in     Normalized_Hydraulic_Pressure_Type
            Flap_Selector_Up         => Flap_Selector_Up,        --in     Boolean
            Flap_Selector_Take_Off   => Flap_Selector_Take_Off,  --in     Boolean
            Flap_Selector_Land       => Flap_Selector_Land,      --in     Boolean
            Flap_Cont_Cb             => Flap_Control_Cb,         --in     Boolean
            Mean_Gear_Position       => Mean_Gear_Position,      --in     Jpats_Landing_Gear_Types.Gear_Position_Type
            Dynamic_Pressure         => Dynamic_Pressure,        --in     Free_Air_Types.Pounds_Per_Sq_Feet
            Fail_Left_Outboard_Flap  => Ios.Left_Outboard_Flap_Fail_Malf,    --in     Boolean
            Fail_Right_Outboard_Flap => Ios.Right_Outboard_Flap_Fail_Malf,   --in     Boolean
            Fail_Left_Wing_Flaps     => Ios.Left_Side_Flaps_Fail_Malf,       --in     Boolean
            Fail_Right_Wing_Flaps    => Ios.Right_Side_Flaps_Fail_Malf,      --in     Boolean
            Fail_All_Malf            => Ios.Flaps_Frozen_Malf);              --: in     Boolean);

      end if;

      -- IOS repeater
      if Flap_Selector_Up then
         Ios.Flap_Handle_Position := 0;
      elsif Flap_Selector_Take_Off then
         Ios.Flap_Handle_Position := 1;
      else
         Ios.Flap_Handle_Position := 2;
      end if;

      -- drive flap indicator
      Extending  := Flaps_Deflection > Gauge_Flap_Position;
      Retracting := Flaps_Deflection < Gauge_Flap_Position;


      if not Freeze_Ind then

         if Extending then

            if Flaps_Deflection - Gauge_Flap_Position <= 30.0 * Iconst then
               Gauge_Flap_Position := Flaps_Deflection;
            else
               Gauge_Flap_Position := Gauge_Flap_Position + 30.0 * Iconst;
            end if;

         elsif Retracting then

            if Gauge_Flap_Position - Flaps_Deflection <= 30.0 * Iconst then
               Gauge_Flap_Position := Flaps_Deflection;
            else
               Gauge_Flap_Position := Gauge_Flap_Position - 30.0 * Iconst;
            end if;

         end if;

      end if;


      --**********************************************************************************************
      if Extending and Gauge_Flap_Position >= 11.5 and Gauge_Flap_Position_Last_Pass < 11.5 then
         Flap_Ind_Timer_1 := Flap_Ind_Timer_1 + Iconst;
      elsif Retracting and Gauge_Flap_Position <= 11.5 and Gauge_Flap_Position_Last_Pass > 11.5 then
         Flap_Ind_Timer_1 := Flap_Ind_Timer_1 + Iconst;
      end if;

      if Flap_Ind_Timer_1 > 0.0 then
         Flap_Ind_Timer_1 := Flap_Ind_Timer_1 + Iconst;
         if Flap_Ind_Timer_1 > 1.5 then
            Flap_Ind_Timer_1 := 0.0;
         end if;
         Gauge_Flap_Position := 11.5;
      end if;
      --**********************************************************************************************
      --**********************************************************************************************
      if Extending and Gauge_Flap_Position >= 23.0 and Gauge_Flap_Position_Last_Pass < 23.0 then
         Flap_Ind_Timer_2 := Flap_Ind_Timer_2 + Iconst;
      elsif Retracting and Gauge_Flap_Position <= 23.0 and Gauge_Flap_Position_Last_Pass > 23.0 then
         Flap_Ind_Timer_2 := Flap_Ind_Timer_2 + Iconst;
      end if;

      if Flap_Ind_Timer_2 > 0.0 then
         Flap_Ind_Timer_2 := Flap_Ind_Timer_2 + Iconst;
         if Flap_Ind_Timer_2 > 1.5 then
            Flap_Ind_Timer_2 := 0.0;
         end if;
         Gauge_Flap_Position := 23.0;
      end if;
      --**********************************************************************************************
      --**********************************************************************************************
      if Extending and Gauge_Flap_Position >= 36.5 and Gauge_Flap_Position_Last_Pass < 36.5 then
         Flap_Ind_Timer_3 := Flap_Ind_Timer_3 + Iconst;
      elsif Retracting and Gauge_Flap_Position <= 36.5 and Gauge_Flap_Position_Last_Pass > 36.5 then
         Flap_Ind_Timer_3 := Flap_Ind_Timer_3 + Iconst;
      end if;

      if Flap_Ind_Timer_3 > 0.0 then
         Flap_Ind_Timer_3 := Flap_Ind_Timer_3 + Iconst;
         if Flap_Ind_Timer_3 > 1.5 then
            Flap_Ind_Timer_3 := 0.0;
         end if;
         Gauge_Flap_Position := 36.5;
      end if;
      --**********************************************************************************************

      Freeze_Ind := (Flap_Ind_Timer_1 > 0.0) or (Flap_Ind_Timer_2 > 0.0) or (Flap_Ind_Timer_3 > 0.0);


      Gauge_Flap_Position_Last_Pass := Gauge_Flap_Position;

      if Ios.Flap_Indicator_Fail_Malf then
         null;
      else
         if Flap_Control_Cb then
            if Gauge_Flap_Position <= 23.0 then
               IO.Flap_Position := 2.0 + (Gauge_Flap_Position/23.0) * 4.0;
            else
               IO.Flap_Position := 6.0 + ((Gauge_Flap_Position-23.0)/27.0)*4.0;
            end if;
         else
            IO.Flap_Position := 0.0;
         end if;
      end if;

      Ios.Flap_Position := Io.Flap_Position; -- IOS repeater

      -- sound
      Sound.Flap_Position_Sound := Flaps_Deflection;

   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Flaps_Controller.Update()");
         raise;
   end Update;

end Jpats_Secondary_Flight_Controls.Flaps_Controller;
