-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls.Container;
with Jpats_Electrical;
with Jpats_Auto_Test;
with Jpats_Secondary_Flight_Controls_Types;
with Jpats_Electrical_Types;
with Force_Types;
with Elevator_Trim;
with Speedbrake;
with Jpats_Simulated_Aircraft;
with Ada.Numerics;
use Ada.Numerics;
with Ada.Numerics.Elementary_Functions; use Ada.Numerics.Elementary_Functions;
with Log;

package body Jpats_Secondary_Flight_Controls.Elevator_Trim_Controller is

   procedure Initialize is
   begin
     Elevator_Trim.Initialize (Container.This_Subsystem.The_Elevator_Trim);
     Elevator_Trim.Read_Tables;
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Elevator_Trim_Controller.Initialize()");
         raise;
   end Initialize;

   Ind_Pwr_Off_Angle : Float renames Container.This_Subsystem.ETC_Ind_Pwr_Off_Angle;
   Ind_Pwr_Up_Angle : Float renames Container.This_Subsystem.ETC_Ind_Pwr_Up_Angle;

   procedure Update
     (Iconst : in Float) is

      package Ctnr renames Container;
      package Sfc_T renames Jpats_Secondary_Flight_Controls_Types;
      package Ele   renames Jpats_Electrical;
      package Ele_T renames Jpats_Electrical_Types;



      Ele_Tab_Mode : constant Integer := Jpats_Auto_Test.Ele_Tab_Mode;
      Auto_Test_Selected : constant Boolean := Ele_Tab_Mode /= 0;
      Auto_Test_Position_Demanded : constant Sfc_T.Elevator_Trim_Position_Type :=
        Sfc_T.Elevator_Trim_Position_Type(Jpats_Auto_Test.Ele_Tab_Pos);

      The_Elevator_Trim : Elevator_Trim.Instance renames Ctnr.This_Subsystem.The_Elevator_Trim;

      Io : Jpats_Secondary_Flight_Controls.Container.Io_Interface_Instance renames Ctnr.This_Io_Interface;

--      Switch_Fwd      : Boolean := Io.Aileron_Elev_Trim_Up_Sw;
--      Switch_Aft      : Boolean := Io.Aileron_Elev_Trim_Dn_Sw;
      Switch_Fwd      : Boolean := Io.Aileron_Elev_Trim_Dn_Sw;
      Switch_Aft      : Boolean := Io.Aileron_Elev_Trim_Up_Sw;
      Trim_Interrupt  : constant Boolean := Io.Trim_Interrupt_Sw;
      Trim_Disconnect : constant Boolean := Io.Trim_Disconnect_Sw;

      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;

      Ail_El_Trim_Cb : constant Boolean := Ele.Is_Powered (Ele_T.Ail_El_Trim_Cb);
      Trim_Ind_Cb    : constant Boolean := Ele.Is_Powered (Ele_T.Trim_Ind_Cb);

      Speedbrake_Position : constant Sfc_T.Speedbrake_Position_Type := Speedbrake.Position (Ctnr.This_Subsystem.The_Speedbrake);

      Position : constant Sfc_T.Elevator_Trim_Position_Type := Elevator_Trim.Position (The_Elevator_Trim);

      Dyn_Px : constant Force_Types.Pounds_Per_Sq_Feet := Jpats_Simulated_Aircraft.Get_Dynamic_Pressure;

      Angle_To_Ind : Float := 0.0;

      Ele_Trim_Act_Pos : Float := 0.0;

      Both_Angles_In_Same_Quadrant : Boolean; --bad name

   begin
      if Auto_Test_Selected then

         if Ele_Tab_Mode = 1 then
            if Auto_Test_Position_Demanded = -1.0 then --< Position then
               Switch_Fwd := False;
               Switch_Aft := True;
            elsif Auto_Test_Position_Demanded = 1.0 then --> Position then
               Switch_Fwd := True;
               Switch_Aft := False;
            else
               Switch_Fwd := False;
               Switch_Aft := False;
            end if;
            Elevator_Trim.Update
              (An_Instance         => The_Elevator_Trim,    -- in out Instance
               Iconst              => Iconst,               -- in     Float
               Electrical_Power    => True,       -- in     Boolean
               Switch_Fwd          => Switch_Fwd,           -- in     Boolean
               Switch_Aft          => Switch_Aft,           -- in     Boolean
               Speedbrake_Position => Speedbrake_Position,  -- in     Speedbrake_Position_Type
               Trim_Interrupt      => False,       -- in     Boolean
               Trim_Disconnect     => False,      -- in     Boolean
               Dynamic_Pressure    => Dyn_Px,
               Fail_Malf           => False,        --: in     Boolean;
               Run_Full_Up_Malf  => False);       --: in     Boolean);
         elsif Ele_Tab_Mode = 2 then
            null;
         elsif Ele_Tab_Mode = 3 then

--             Elevator_Trim.Set_Position
--               (An_Instance  => The_Elevator_Trim,
--                Tab_Position => Auto_Test_Position_Demanded);

            Elevator_Trim.Set_Position
              (An_Instance         => The_Elevator_Trim, -- in out Instance;
               Tab_Position        => Auto_Test_Position_Demanded, -- in     Float;
               Speedbrake_Position => Speedbrake_Position, -- in     Jpats_Secondary_Flight_Controls_Types.Speedbrake_Position_Type;
               Dynamic_Pressure    => Dyn_Px); -- in     Force_Types.Pounds_Per_Sq_Feet)




         else
            null;
         end if;

--          if Auto_Test_Position_Demanded < Position then
--             Switch_Fwd := False;
--             Switch_Aft := True;
--          elsif Auto_Test_Position_Demanded > Position then
--             Switch_Fwd := True;
--             Switch_Aft := False;
--          else
--             Switch_Fwd := False;
--             Switch_Aft := False;
--          end if;


--          Elevator_Trim.Update
--            (An_Instance         => The_Elevator_Trim,    -- in out Instance
--             Iconst              => Iconst,               -- in     Float
--             Electrical_Power    => Ail_El_Trim_Cb,       -- in     Boolean
--             Switch_Fwd          => Switch_Fwd,           -- in     Boolean
--             Switch_Aft          => Switch_Aft,           -- in     Boolean
--             Speedbrake_Position => Speedbrake_Position,  -- in     Speedbrake_Position_Type
--             Trim_Interrupt      => Trim_Interrupt,       -- in     Boolean
         --             Trim_Disconnect     => Trim_Disconnect);     -- in     Boolean
         -- dynamic_pressure ********************************
      else
         Elevator_Trim.Update
           (An_Instance         => The_Elevator_Trim,    -- in out Instance
            Iconst              => Iconst,               -- in     Float
            Electrical_Power    => Ail_El_Trim_Cb,       -- in     Boolean
            Switch_Fwd          => Switch_Fwd,           -- in     Boolean
            Switch_Aft          => Switch_Aft,           -- in     Boolean
            Speedbrake_Position => Speedbrake_Position,  -- in     Speedbrake_Position_Type
            Trim_Interrupt      => Trim_Interrupt,       -- in     Boolean
            Trim_Disconnect     => Trim_Disconnect,       -- in     Boolean
            Dynamic_Pressure    => Dyn_Px,
            Fail_Malf           => Ios.Elevator_Trim_Fail_Malf,        --: in     Boolean;
            Run_Full_Up_Malf  => Ios.Elevator_Trim_Full_Down_Malf);  --: in     Boolean);
      end if;

      -- drive trim elevator trim indicator
      Ele_Trim_Act_Pos := Elevator_Trim.Actuated_Position(The_Elevator_Trim);

      if Ele_Trim_Act_Pos <= -1.29629629629 then
         Angle_To_Ind := 3.375 * Ele_Trim_Act_Pos + 364.375;
         if Angle_To_Ind < 340.75 then Angle_To_Ind := 340.75; end if;
         if Angle_To_Ind > 360.0  then Angle_To_Ind := 360.0;  end if;
      else
         Angle_To_Ind := 3.375 * Ele_Trim_Act_Pos + 4.375;
         if Angle_To_Ind < 0.0   then Angle_To_Ind := 0.0;   end if;
         if Angle_To_Ind > 75.25 then Angle_To_Ind := 75.25; end if;
      end if;

      Ios.Elevator_Trim_Deflection_Angle := Ele_Trim_Act_Pos;
      Ios.Elevator_Trim_Angle := Angle_To_Ind;

      if Trim_Ind_Cb then

         Both_Angles_In_Same_Quadrant := ((Angle_To_Ind <= 90.0 and Ind_Pwr_Up_Angle <= 90.0)
                                          or
                                          (Angle_To_Ind > 90.0 and Ind_Pwr_Up_Angle > 90.0));

         if abs(Angle_To_Ind - Ind_Pwr_Up_Angle) <= (10.0*Iconst) then
            Ind_Pwr_Up_Angle := Angle_To_Ind;
         elsif Both_Angles_In_Same_Quadrant then
            if Angle_To_Ind - Ind_Pwr_Up_Angle > 0.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle + 10.0*Iconst;
            elsif Angle_To_Ind - Ind_Pwr_Up_Angle < 0.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle - 10.0*Iconst;
            end if;
         else
            if Angle_To_Ind <= 90.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle + 10.0*Iconst;
               if Ind_Pwr_Up_Angle > 360.0 then Ind_Pwr_Up_Angle := 0.0; end if;
            elsif Ind_Pwr_Up_Angle <= 90.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle - 10.0*Iconst;
               if Ind_Pwr_Up_Angle < 0.0 then Ind_Pwr_Up_Angle := 360.0; end if;
            end if;
         end if;


         Io.Trim_Pos_Chan_3_Sine   := 10.0*Sin(Ind_Pwr_Up_Angle,360.0);
         Io.Trim_Pos_Chan_3_Cosine := 10.0*Cos(Ind_Pwr_Up_Angle,360.0);
         Ind_Pwr_Off_Angle := Ind_Pwr_Up_Angle;

      else

         if Ind_Pwr_Off_Angle < 0.0 then Ind_Pwr_Off_Angle := 360.0; end if;
         Ind_Pwr_Off_Angle := Ind_Pwr_Off_Angle - 10.0*Iconst;
         if Ind_Pwr_Off_Angle < 275.5 and Ind_Pwr_Off_Angle > 75.25 then Ind_Pwr_Off_Angle := 275.5; end if;
         Io.Trim_Pos_Chan_3_Sine   := 10.0*Sin(Ind_Pwr_Off_Angle,360.0);
         Io.Trim_Pos_Chan_3_Cosine := 10.0*Cos(Ind_Pwr_Off_Angle,360.0);
         Ind_Pwr_Up_Angle := Ind_Pwr_Off_Angle;

      end if;

   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Elevator_Trim_Controller.Update()");
         raise;
   end Update;

end Jpats_Secondary_Flight_Controls.Elevator_Trim_Controller;




