-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Buffet_G;

with Aircraft_Flaps,
     Speedbrake,
     Aileron_Trim,
     Elevator_Trim,
     Rudder_Trim,
     Tad;

private package Jpats_Secondary_Flight_Controls.Container is

   package Buffet_Flap is new Buffet_G
     (Position_Type      => Float,
      Airspeed_Type      => Float,
      Buffet_Type        => Float,
      Min_Deflection     => 25.0,
      Airspeed_Threshold => 80.0,
      Airspeed_Gain      => 1.0/230.0,
      Gain               => 0.01,
      Package_Name       => "Jpats_Secondary_Flight_Controls.Container.Buffet_Flap");
   package Buffet_Speedbrake is new Buffet_G
     (Position_Type      => Float,
      Airspeed_Type      => Float,
      Buffet_Type        => Float,
      Min_Deflection     => 0.1,
      Airspeed_Threshold => 100.0,
      Airspeed_Gain      => 1.0/230.0,
      Gain               => 0.01,
      Package_Name       => "Jpats_Secondary_Flight_Controls.Container.Buffet_Speedbrake");

   type Instance is
      record
         The_Flaps             : Aircraft_Flaps.Instance;
         The_Speedbrake        : Speedbrake.Instance;
         The_Aileron_Trim      : Aileron_Trim.Instance;
         The_Elevator_Trim     : Elevator_Trim.Instance;
         The_Rudder_Trim       : Rudder_Trim.Instance;
         The_Tad               : Tad.Instance;
         The_Flap_Buffet       : Buffet_Flap.Instance;
         The_Speedbrake_Buffet : Buffet_Speedbrake.Instance;

         ATC_Ind_Pwr_Off_Angle : Float := 0.0;
         ATC_Ind_Pwr_Up_Angle  : Float := 0.0;

         ETC_Ind_Pwr_Off_Angle : Float := 0.0;
         ETC_Ind_Pwr_Up_Angle  : Float := 0.0;

         RTC_Ind_Pwr_Off_Angle : Float := 0.0;
         RTC_Ind_Pwr_Up_Angle  : Float := 0.0;

         FC_Flap_Ind_Timer_1 : Float := 0.0;
         FC_Flap_Ind_Timer_2 : Float := 0.0;
         FC_Flap_Ind_Timer_3 : Float := 0.0;

         FC_Gauge_Flap_Position : Float := 0.0;
         FC_Gauge_Flap_Position_Last_Pass : Float := 0.0;

         FC_Extending : Boolean := False;
         FC_Retracting : Boolean := False;
         FC_Freeze_Ind : Boolean := False;

      end record;
   This_Subsystem : Instance;

   type Io_Interface_Instance is
      record
         -- digital input
         Trim_Aid_On_Sw                  : Boolean := False;
         Trim_Disconnect_Sw              : Boolean := False;
         Rudder_Trim_Sw_Left             : Boolean := False;
         Rudder_Trim_Sw_Right            : Boolean := False;
         Speed_Brake_Retract_Sw          : Boolean := False;
         Speed_Brake_Extend_Sw           : Boolean := False;
         Flap_Cont_To_Sw                 : Boolean := False;
         Flap_Cont_Land_Sw               : Boolean := False;
         Flap_Cont_Up_Sw                 : Boolean := True;
         Speed_Brake_Max_Pwr_Sw          : Boolean := False;
         Aileron_Elev_Trim_Dn_Sw         : Boolean := False;
         Aileron_Elev_Trim_Left_Sw       : Boolean := False;
         Aileron_Elev_Trim_Up_Sw         : Boolean := False;
         Aileron_Elev_Trim_Right_Sw      : Boolean := False;
         Trim_Interrupt_Sw               : Boolean := False;

         --digital output
         Speed_Brake_Ann                 : Boolean := False;
         Lh_Sw_Cont_Trim_Aid_Sw          : Boolean := False;
         -- analog input
         -- analog output
         Flap_Position                   : Float := 0.0;
         Trim_Pos_Chan_1_Sine            : Float := 0.0;
         Trim_Pos_Chan_1_Cosine          : Float := 0.0;
         Trim_Pos_Chan_2_Sine            : Float := 0.0;
         Trim_Pos_Chan_2_Cosine          : Float := 0.0;
         Trim_Pos_Chan_3_Sine            : Float := 0.0;
         Trim_Pos_Chan_3_Cosine          : Float := 0.0;
         --spare
         Spare_Io_1                      : Boolean := False;
      end record;

   Io_Size : constant Integer := 4;
   for Io_Interface_Instance use
      record
         --spare
         Spare_Io_1                      at  000*Io_Size range 0..31;
         -- digital input
         Trim_Aid_On_Sw                  at  001*Io_Size range 0..31;
         Trim_Disconnect_Sw              at  002*Io_Size range 0..31;
         Rudder_Trim_Sw_Left             at  003*Io_Size range 0..31;
         Rudder_Trim_Sw_Right            at  004*Io_Size range 0..31;
         Speed_Brake_Retract_Sw          at  005*Io_Size range 0..31;
         Speed_Brake_Extend_Sw           at  006*Io_Size range 0..31;
         Flap_Cont_To_Sw                 at  007*Io_Size range 0..31;
         Flap_Cont_Land_Sw               at  008*Io_Size range 0..31; --DNE
         Flap_Cont_Up_Sw                 at  009*Io_Size range 0..31;
         Speed_Brake_Max_Pwr_Sw          at  010*Io_Size range 0..31;
         Aileron_Elev_Trim_Dn_Sw         at  011*Io_Size range 0..31;
         Aileron_Elev_Trim_Left_Sw       at  012*Io_Size range 0..31;
         Aileron_Elev_Trim_Up_Sw         at  013*Io_Size range 0..31;
         Aileron_Elev_Trim_Right_Sw      at  014*Io_Size range 0..31;
         Trim_Interrupt_Sw               at  015*Io_Size range 0..31;

         --digital output
         Speed_Brake_Ann                 at  016*Io_Size range 0..31;
         Lh_Sw_Cont_Trim_Aid_Sw          at  017*Io_Size range 0..31;
         -- analog input
         -- analog output
         Flap_Position                   at  018*Io_Size range 0..31;
         Trim_Pos_Chan_1_Sine            at  019*Io_Size range 0..31;
         Trim_Pos_Chan_1_Cosine          at  020*Io_Size range 0..31;
         Trim_Pos_Chan_2_Sine            at  021*Io_Size range 0..31;
         Trim_Pos_Chan_2_Cosine          at  022*Io_Size range 0..31;
         Trim_Pos_Chan_3_Sine            at  023*Io_Size range 0..31;
         Trim_Pos_Chan_3_Cosine          at  024*Io_Size range 0..31;
      end record;
   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         Speedbrake_Deployed                : Boolean := False;

         Elevator_Trim_Angle                : Float := 0.0;
         Aileron_Trim_Angle                 : Float := 0.0;
         Rudder_Trim_Angle                  : Float := 0.0;

         Elevator_Trim_Deflection_Angle     : Float := 0.0;
         Aileron_Trim_Deflection_Angle      : Float := 0.0;
         Rudder_Trim_Deflection_Angle       : Float := 0.0;


         Flap_Handle_Position               : Integer := 0;
         Flap_Position                      : Float := 0.0;

         Elevator_Trim_Full_Down_Malf       : Boolean := False;
         Elevator_Trim_Fail_Malf            : Boolean := False;

         Aileron_Trim_Full_Roll_Right_Malf  : Boolean := False;
         Aileron_Trim_Fail_Malf             : Boolean := False;

         Rudder_Trim_Full_Right_Malf        : Boolean := False;
         Rudder_Trim_Fail_Malf              : Boolean := False;


         Left_Outboard_Flap_Fail_Malf       : Boolean := False;
         Right_Outboard_Flap_Fail_Malf      : Boolean := False;
         Left_Side_Flaps_Fail_Malf          : Boolean := False;
         Right_Side_Flaps_Fail_Malf         : Boolean := False;
         Flaps_Frozen_Malf                  : Boolean := False;

         Flap_Indicator_Fail_Malf           : Boolean := False;

         --Ios_Pilot_Enable                   : Boolean := False;
         Ios_Pilot_Flaps                    : Integer := 0;
         Ios_Pilot_Speed_Brake              : Integer := 0;

      end record;
   This_Ios_Interface : Ios_Interface_Instance;

   type Sound_Interface_Instance is
      record
         Flap_Position_Sound             : Float := 0.0;
         Speedbrake_Position             : Float := 0.0;
      end record;
   This_Sound_Interface : Sound_Interface_Instance;


end Jpats_Secondary_Flight_Controls.Container;
