-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls.Container;
with Speedbrake;
with Aircraft_Flaps;
with Jpats_Landing_Gear;
with Jpats_Landing_Gear_Types;
with Jpats_Simulated_Aircraft;
--with Jpats_Electrical;
with Log;

package body Jpats_Secondary_Flight_Controls.Buffet_Controller is

   procedure Initialize is
   begin
      Container.Buffet_Flap.Initialize (Container.This_Subsystem.The_Flap_Buffet);
      Container.Buffet_Speedbrake.Initialize (Container.This_Subsystem.The_Speedbrake_Buffet);

   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Buffet_Controller.Initialize()");
         raise;
   end Initialize;

   procedure Update
     (Iconst : in Float) is
      package Ctnr renames Container;
      package Brake renames Speedbrake;
      package Flaps renames Aircraft_Flaps;
      package Gear renames Jpats_Landing_Gear;
      package Gear_T renames Jpats_Landing_Gear_Types;
      package Simulated_Aircraft renames Jpats_Simulated_Aircraft;

      The_Flap_Buffet : Ctnr.Buffet_Flap.Instance renames Ctnr.This_Subsystem.The_Flap_Buffet;
      The_Speedbrake_Buffet : Ctnr.Buffet_Speedbrake.Instance renames Ctnr.This_Subsystem.The_Speedbrake_Buffet;
      The_Speedbrake : brake.Instance renames Ctnr.This_Subsystem.The_Speedbrake;
      The_Flaps : Flaps.Instance renames Ctnr.This_Subsystem.The_Flaps;

      Airspeed : constant Float := Float (Simulated_Aircraft.Get_True_Airspeed);
      Wow : constant Boolean := Gear.Is_Closed (Gear_T.Left_Landing_Gear_A1_WOW_Relay);

   begin

      Ctnr.Buffet_Flap.Update
        (An_Instance => The_Flap_Buffet,
         Deflection  => Flaps.Deflection (The_Flaps),
         Airspeed    => Airspeed,
         Wow         => Wow);

      Ctnr.Buffet_Speedbrake.Update
        (An_Instance => The_Speedbrake_Buffet,
         Deflection  => Brake.Position (The_Speedbrake),
         Airspeed    => Airspeed,
         Wow         => Wow);

   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Buffet_Controller.Update()");
         raise;
   end Update;

end Jpats_Secondary_Flight_Controls.Buffet_Controller;
