-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  AILERON TRIM
--  An electromechanical actuator, installed in the center wing,
--  is connected to a spring box assembly and the centerline
--  bellcrank to provide aileron (roll) trim by actually moving
--  the ailerons. The aileron trim actuator is controlled by A
--  combined roll/pitch trim switch located on the control stick
--  grip in each cockpit. Aileron travel for roll trim is limited to
--  6 trailing edge up for either aileron and 3 trailing edge
--  down for the opposite aileron. Trim position is indicated on
--  the triple trim indicator on the trim control panel (Figure 1-
--  26). Power is provided through a circuit breaker placarded
--  AIL/EL TRIM, located on the battery bus circuit breaker
--  panel in the front cockpit.
--  Ground adjustable trim tabs are installed at the trailing edge
--  of each aileron. The tabs allow maintenance adjustment of
--  the stick neutral trim input to the control system by varying
--  the aerodynamic forces acting on the ailerons. The ground
--  adjustable trim tabs are limited to 20 tab trailing edge up
--  and 8 tab trailing edge down.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------
private package Jpats_Secondary_Flight_Controls.Aileron_Trim_Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Secondary_Flight_Controls.Aileron_Trim_Controller;
