-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls.Container;
with Jpats_Electrical;
with Jpats_Auto_Test;
with Jpats_Secondary_Flight_Controls_Types;
with Jpats_Electrical_Types;
with Aileron_Trim;
with Ada.Numerics; use Ada.Numerics;
with Ada.Numerics.Elementary_Functions; use Ada.Numerics.Elementary_Functions;
with Log;

package body Jpats_Secondary_Flight_Controls.Aileron_Trim_Controller is

   procedure Initialize
   is
   begin
      Aileron_Trim.Initialize(Container.This_Subsystem.The_Aileron_Trim);
   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Aileron_Trim_Controller.Initialize()");
         raise;
   end Initialize;

   Ind_Pwr_Off_Angle : Float renames Container.This_Subsystem.ATC_Ind_Pwr_Off_Angle;
   Ind_Pwr_Up_Angle : Float renames Container.This_Subsystem.ATC_Ind_Pwr_Up_Angle;

   procedure Update
     (Iconst : in Float)
   is

      package Ctnr  renames Container;
      package Sfc_T renames Jpats_Secondary_Flight_Controls_Types;
      package Ele   renames Jpats_Electrical;
      package Ele_T renames Jpats_Electrical_Types;

      Auto_Test_Selected          : constant Boolean := Jpats_Auto_Test.On;
      Auto_Test_Position_Demanded : constant Sfc_T.Aileron_Trim_Position_Type := Sfc_T.Aileron_Trim_Position_Type(Jpats_Auto_Test.Ail_Trim);

      Ail_El_Trim_Cb : constant Boolean := Ele.Is_Powered (Ele_T.Ail_El_Trim_Cb);
      Trim_Ind_Cb    : constant Boolean := Ele.Is_Powered (Ele_T.Trim_Ind_Cb);

      The_Aileron_Trim : Aileron_Trim.Instance renames Ctnr.This_Subsystem.The_Aileron_Trim;

      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;

      Switch_Left     : Boolean := Io.Aileron_Elev_Trim_Left_Sw;
      Switch_Right    : Boolean := Io.Aileron_Elev_Trim_Right_Sw;

      Trim_Interrupt  : constant Boolean := Io.Trim_Interrupt_Sw;
      Trim_Disconnect : constant Boolean := Io.Trim_Disconnect_Sw;

      Position : constant Sfc_T.Aileron_Trim_Position_Type := Aileron_Trim.Position (The_Aileron_Trim);

      Angle_To_Ind : Float := 0.0;
      Ail_Trim_Pos : Float := 0.0;

      Both_Angles_In_Same_Quadrant : Boolean; --bad name

   begin


      if Auto_Test_Position_Demanded = -1.0 then
         Switch_Left  := False;
         Switch_Right := True;

         Aileron_Trim.Update
           (An_Instance      => The_Aileron_Trim,
            Iconst           => Iconst,
            Electrical_Power => Ail_El_Trim_Cb,
            Switch_Left      => Switch_Left,
            Switch_Right     => Switch_Right,
            Trim_Interrupt   => Trim_Interrupt,
            Trim_Disconnect  => Trim_Disconnect,
            Trim_Fail_Malf   => Ios.Aileron_Trim_Fail_Malf,
            Roll_Right_Malf  => Ios.Aileron_Trim_Full_Roll_Right_Malf);

      elsif Auto_Test_Position_Demanded = 1.0 then
         Switch_Left  := True;
         Switch_Right := False;

         Aileron_Trim.Update
           (An_Instance      => The_Aileron_Trim,
            Iconst           => Iconst,
            Electrical_Power => Ail_El_Trim_Cb,
            Switch_Left      => Switch_Left,
            Switch_Right     => Switch_Right,
            Trim_Interrupt   => Trim_Interrupt,
            Trim_Disconnect  => Trim_Disconnect,
            Trim_Fail_Malf   => Ios.Aileron_Trim_Fail_Malf,
            Roll_Right_Malf  => Ios.Aileron_Trim_Full_Roll_Right_Malf);

      elsif Auto_Test_Position_Demanded /= 0.0 then

         if not (abs(Auto_Test_Position_Demanded) > 1.0) then
            Aileron_Trim.set_position
              (An_Instance      => The_Aileron_Trim,
               Iconst           => Iconst,
               Position         => Auto_Test_Position_Demanded
               );
         end if;


      else
         Aileron_Trim.Update
           (An_Instance      => The_Aileron_Trim,
            Iconst           => Iconst,
            Electrical_Power => Ail_El_Trim_Cb,
            Switch_Left      => Switch_Left,
            Switch_Right     => Switch_Right,
            Trim_Interrupt   => Trim_Interrupt,
            Trim_Disconnect  => Trim_Disconnect,
            Trim_Fail_Malf   => Ios.Aileron_Trim_Fail_Malf,
            Roll_Right_Malf  => Ios.Aileron_Trim_Full_Roll_Right_Malf);
      end if;


--       if Auto_Test_Selected then
--          if Auto_Test_Position_Demanded < Position then
--             Switch_Left  := False;
--             Switch_Right := True;
--          elsif Auto_Test_Position_Demanded > Position then
--             Switch_Left  := True;
--             Switch_Right := False;
--          else
--             Switch_Left  := False;
--             Switch_Right := False;
--          end if;
--          Aileron_Trim.Update
--            (An_Instance      => The_Aileron_Trim,
--             Iconst           => Iconst,
--             Electrical_Power => True,
--             Switch_Left      => Switch_Left,
--             Switch_Right     => Switch_Right,
--             Trim_Interrupt   => False,
--             Trim_Disconnect  => False,
--             Trim_Fail_Malf   => False,     --: in     Boolean;
--             Roll_Right_Malf  => False);    --: in     Boolean);


-- --          Aileron_Trim.Update
-- --            (An_Instance      => The_Aileron_Trim,
-- --             Iconst           => Iconst,
-- --             Electrical_Power => Ail_El_Trim_Cb,
-- --             Switch_Left      => Switch_Left,
-- --             Switch_Right     => Switch_Right,
-- --             Trim_Interrupt   => Trim_Interrupt,
-- --             Trim_Disconnect  => Trim_Disconnect);
--       --************add malfs to call********************

--       else
--          Aileron_Trim.Update
--            (An_Instance      => The_Aileron_Trim,
--             Iconst           => Iconst,
--             Electrical_Power => Ail_El_Trim_Cb,
--             Switch_Left      => Switch_Left,
--             Switch_Right     => Switch_Right,
--             Trim_Interrupt   => Trim_Interrupt,
--             Trim_Disconnect  => Trim_Disconnect,
--             Trim_Fail_Malf   => Ios.Aileron_Trim_Fail_Malf,
--             Roll_Right_Malf  => Ios.Aileron_Trim_Full_Roll_Right_Malf);
--       end if;

      -- value to triple trim indicator
      Ail_Trim_Pos := Aileron_Trim.Position(The_Aileron_Trim);

      if Ail_Trim_Pos <= 0.0 then
         Angle_To_Ind := -Ail_Trim_Pos*50.0;
         if Angle_To_Ind < 0.0  then Angle_To_Ind := 0.0;  end if;
         if Angle_To_Ind > 50.0 then Angle_To_Ind := 50.0; end if;
      else
         Angle_To_Ind := 360.0-Ail_Trim_Pos*50.0;
         if Angle_To_Ind < 310.0 then Angle_To_Ind := 310.0; end if;
         if Angle_To_Ind > 360.0 then Angle_To_Ind := 360.0; end if;
      end if;

      Ios.Aileron_Trim_Angle := Angle_To_Ind;
      Ios.Aileron_Trim_Deflection_Angle := Ail_Trim_Pos;

      if Trim_Ind_Cb then

         Both_Angles_In_Same_Quadrant := ((Angle_To_Ind <= 90.0 and Ind_Pwr_Up_Angle <= 90.0)
                                          or
                                          (Angle_To_Ind > 90.0 and Ind_Pwr_Up_Angle > 90.0));

         if abs(Angle_To_Ind - Ind_Pwr_Up_Angle) <= (10.0*Iconst) then
            Ind_Pwr_Up_Angle := Angle_To_Ind;
         elsif Both_Angles_In_Same_Quadrant then
            if Angle_To_Ind - Ind_Pwr_Up_Angle > 0.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle + 10.0*Iconst;
            elsif Angle_To_Ind - Ind_Pwr_Up_Angle < 0.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle - 10.0*Iconst;
            end if;
         else
            if Angle_To_Ind <= 90.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle + 10.0*Iconst;
               if Ind_Pwr_Up_Angle > 360.0 then Ind_Pwr_Up_Angle := 0.0; end if;
            elsif Ind_Pwr_Up_Angle <= 90.0 then
               Ind_Pwr_Up_Angle := Ind_Pwr_Up_Angle - 10.0*Iconst;
               if Ind_Pwr_Up_Angle < 0.0 then Ind_Pwr_Up_Angle := 360.0; end if;
            end if;
         end if;

         Io.Trim_Pos_Chan_1_Sine   := 10.0*Sin(Ind_Pwr_Up_Angle,360.0);
         Io.Trim_Pos_Chan_1_Cosine := 10.0*Cos(Ind_Pwr_Up_Angle,360.0);
         Ind_Pwr_Off_Angle := Ind_Pwr_Up_Angle;

      else
         if Ind_Pwr_Off_Angle < 0.0 then Ind_Pwr_Off_Angle := 360.0; end if;
         Ind_Pwr_Off_Angle := Ind_Pwr_Off_Angle - 10.0*Iconst;
         if Ind_Pwr_Off_Angle < 276.0 and Ind_Pwr_Off_Angle > 50.0 then Ind_Pwr_Off_Angle := 276.0; end if;
         Io.Trim_Pos_Chan_1_Sine   := 10.0*Sin(Ind_Pwr_Off_Angle,360.0);
         Io.Trim_Pos_Chan_1_Cosine := 10.0*Cos(Ind_Pwr_Off_Angle,360.0);
         Ind_Pwr_Up_Angle := Ind_Pwr_Off_Angle;

      end if;

   exception
      when others =>
         Log.Report("Jpats_Secondary_Flight_Controls.Aileron_Trim_Controller.Update()");
         raise;
   end Update;

end Jpats_Secondary_Flight_Controls.Aileron_Trim_Controller;
