-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Flap is

   procedure Extend
     (An_Instance       : in out Instance;
      Rate              : in     Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
      Position_Demanded : in     Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type)
   is
   begin
      if (Position_Demanded - An_Instance.Position) < Rate then
         An_Instance.Position := Position_Demanded;
      else
         An_Instance.Position := An_Instance.Position + Rate;
      end if;
   exception
      when others =>
         Log.Report("Flap.Extend()");
         raise;
   end Extend;

   procedure Retract
     (An_Instance       : in out Instance;
      Rate              : in     Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
      Position_Demanded : in     Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type)
   is
   begin
      if (An_Instance.Position - Position_Demanded) < Rate then
         An_Instance.Position := Position_Demanded;
      else
         An_Instance.Position := An_Instance.Position - Rate;
      end if;
   exception
      when others =>
         Log.Report("Flap.Retract()");
         raise;
   end Retract;

   function Position
     (An_Instance : in Instance)
     return Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type
   is
   begin
      return An_Instance.Position;
   exception
      when others =>
         Log.Report("Flap.Position()");
         raise;
   end Position;

end Flap;
