-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with System;

generic
   type Position_Type is digits <>;
   type Airspeed_Type is digits <>;
   type Buffet_Type is digits <>;
   Min_Deflection     : in Position_Type;
   Airspeed_Threshold : in Airspeed_Type;
   Airspeed_Gain      : in Buffet_Type;
   Gain               : in Buffet_Type;
   Package_Name       :  String;
--   with function Convert_To_Float (PData : System.Address) return Float is <>;
--   type Ios_Variable_Type is (<>);
--   type Set_Variable_Proc_Ptr_Type is access procedure(PData : System.Address);
--   with procedure Register_Debug_Variable
--     ( Annotation_String     : in String;
--       Units_String          : in String;
--       Variable_Address      : in System.Address;
--       Set_Variable_Proc_Ptr : in Set_Variable_Proc_Ptr_Type;
--       Type_Of_IOS_Variable  : in IOS_Variable_Type;
--       Minimum_Value_of_Var  : in Float;
--       Maximum_Value_of_Var  : in Float ) is <>;

package Buffet_G is
  type Instance is private;
--  type Position_Type is new Float;
--  type Airspeed_Type is new Float;
--  type Buffet_Type is new Float;

  procedure Update
     (An_Instance : in out Instance;
      Deflection  : in     Position_Type;
      Airspeed    : in     Airspeed_Type;
      Wow         : in     Boolean);

  procedure Initialize
    (An_Instance   : in out Instance);
 --    Instance_Name : in     String);

  function Buffet
     (An_Instance : in Instance)
      return Buffet_Type;

private

  type Instance is record
     Buffet             : Buffet_Type;
  end record;

end Buffet_G;

