-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- with System;
with Log;
-- with Jpats_Ios_Interface;

package body Buffet_G is

--  Min_Deflection     : Position_Type := Position_Type(0.1);
--  Airspeed_Threshold : Airspeed_Type := Airspeed_Type(100.0);
--  Airspeed_Gain      : Buffet_Type   := Buffet_Type(0.01);
--  Gain               : Buffet_Type   := Buffet_Type(0.01);

--  procedure Min_Deflection_Accessor
--    (PData : System.Address) is
--  begin
--    Min_Deflection := Position_Type(Convert_To_Float(PData));
--  end Min_Deflection_Accessor;
--
--  procedure Airspeed_Threshold_Accessor
--    (PData : System.Address) is
--  begin
--    Airspeed_Threshold := Airspeed_Type(Convert_To_Float(PData));
--  end Airspeed_Threshold_Accessor;
--
--  procedure Airspeed_Gain_Accessor
--    (PData : System.Address) is
--  begin
--    Airspeed_Gain := Buffet_Type(Convert_To_Float(PData));
--  end Airspeed_Gain_Accessor;
--
--  procedure Gain_Accessor
--    (PData : System.Address) is
--  begin
--    Gain := Buffet_Type(Convert_To_Float(PData));
--  end Gain_Accessor;

  procedure Update
    (An_Instance : in out Instance;
     Deflection  : in     Position_Type;
     Airspeed    : in     Airspeed_Type;
     Wow         : in     Boolean) is

    Airspeed_Difference : Airspeed_Type := 0.0;
  begin

    --      if (Airspeed - Airspeed_Threshold) > 1.0 then
    --         Airspeed_Difference := 1.0;
    --      elsif (Airspeed - Airspeed_Threshold) < 0.0 then
    --         Airspeed_Difference := 0.0;
    --      else
    --         Airspeed_Difference := Airspeed - Airspeed_Threshold;
    --      end if;

    Airspeed_Difference := Airspeed_Type(float'Max(0.0,Float'Min(1.0,Float((Airspeed - Airspeed_Threshold))*Float(Airspeed_Gain))));

    if ((Deflection >= Min_Deflection) and not Wow) then
      An_Instance.Buffet := Gain * Buffet_Type (Deflection) * Buffet_Type (Airspeed_Difference);
    else
      An_Instance.Buffet := 0.0;
    end if;
  exception
    when others =>
      Log.Report(Package_Name & ".Update()");
      raise;
  end Update;

  procedure Initialize
    (An_Instance   : in out Instance)
--     Instance_Name : in     String);
  is
  begin
    An_Instance.Buffet := 0.0;
--    Register_Debug_Variable
--      ( Annotation_String      => Package_Name & ".Min_Deflection",
--        Units_String           => "Float",
--        Variable_Address       => Min_Deflection'Address,
--        Set_Variable_Proc_Ptr  => Min_Deflection_Accessor'Access,
--        Type_Of_IOS_Variable   => Ios_Variable_Type,
--        Minimum_Value_of_Var   => -1.0,
--        Maximum_Value_of_Var   => 1.0 );

--    Register_Debug_Variable
--      ( Annotation_String      => Package_Name & ".Airspeed_Threshold",
--        Units_String           => "Float",
--        Variable_Address       => Airspeed_Threshold'Address,
--        Set_Variable_Proc_Ptr  => Airspeed_Threshold_Accessor'Access,
--        Type_Of_IOS_Variable   => Ios_Variable_Type,
--        Minimum_Value_of_Var   => 0.0,
--        Maximum_Value_of_Var   => 1000.0 );

--    Register_Debug_Variable
--      ( Annotation_String      => Package_Name & ".Airspeed_Gain",
--        Units_String           => "Float",
--        Variable_Address       => Airspeed_Gain'Address,
--        Set_Variable_Proc_Ptr  => Airspeed_Gain_Accessor'Access,
--        Type_Of_IOS_Variable   => Ios_Variable_Type,
--        Minimum_Value_of_Var   => -10.0,
--        Maximum_Value_of_Var   => 10.0 );

--    Register_Debug_Variable
--      ( Annotation_String      => Package_Name & ".Gain",
--        Units_String           => "Float",
--        Variable_Address       => Gain'Address,
--        Set_Variable_Proc_Ptr  => Gain_Accessor'Access,
--        Type_Of_IOS_Variable   => Ios_Variable_Type,
--        Minimum_Value_of_Var   => -10.0,
--        Maximum_Value_of_Var   => 10.0 );

  exception
    when others =>
      Log.Report(Package_Name & ".Initialize()");
      raise;
  end Initialize;

  function Buffet
    (An_Instance : in Instance)
    return Buffet_Type is
  begin
    return An_Instance.Buffet;
  exception
    when others =>
      Log.Report(Package_Name & ".Buffet()");
      raise;
  end Buffet;

end Buffet_G;








