-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls_Types;
with Jpats_Hydraulics_Types;
with Electrical_Units_Types;
with Jpats_Landing_Gear_Types;
with Force_Types;
with Length_Types;

package Aircraft_Flaps is

   type Instance is private;

   procedure Initialize
     (An_Instance : in out Instance);

   function Hydraulic_Load
     (An_Instance : in Instance)
      return Length_Types.Gpm;

   function Asymmetry
     (An_Instance : in Instance)
      return Jpats_Secondary_Flight_Controls_Types.Flap_Asymmetry_Type;

   function Load
     (An_Instance : in Instance)
      return Electrical_Units_Types.Amps;

   function Deflection
     (An_Instance : in Instance)
      return Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;

   procedure Update
     (An_Instance              : in out Instance;
      Iconst                   : in     Float;
      Emerg_Gear_Handle_Extend : in     Boolean;
      Primary_Hyd_Fcn          : in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
      Emerg_Hyd_Fcn            : in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
      Flap_Selector_Up         : in     Boolean;
      Flap_Selector_Take_Off   : in     Boolean;
      Flap_Selector_Land       : in     Boolean;
      Flap_Cont_Cb             : in     Boolean;
      Mean_Gear_Position       : in     Jpats_Landing_Gear_Types.Gear_Position_Type;
      Dynamic_Pressure         : in     Force_Types.Pounds_Per_Sq_Feet;
      Fail_Left_Outboard_Flap  : in     Boolean;
      Fail_Right_Outboard_Flap : in     Boolean;
      Fail_Left_Wing_Flaps     : in     Boolean;
      Fail_Right_Wing_Flaps    : in     Boolean;
      Fail_All_Malf            : in     Boolean);

private

   type Instance is
      record
         Deflection           : Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
         Actuated_Deflection  : Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
         Deflection_Commanded : Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
         Asymmetry            : Jpats_Secondary_Flight_Controls_Types.Flap_Asymmetry_Type;
         Hydraulic_Load       : Length_Types.Gpm;
         Load                 : Electrical_Units_Types.Amps;
         Take_Off_Piston_Position : Float; --Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
         Landing_Piston_Position  : Float; --Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
--          Take_Off_Piston_Position : Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
--          Landing_Piston_Position  : Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;

      end record;

end Aircraft_Flaps;
