-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Secondary_Flight_Controls_Types;

with Electrical_Units_Types;

package Aileron_Trim is

   type Instance is private;

   procedure Initialize
     (An_Instance : in out Instance);

   procedure Set_Position
     (An_Instance : in out Instance;
      Iconst      : in     Float;
      Position    : in     Float);

   function Position
     (An_Instance : in Instance)
      return Jpats_Secondary_Flight_Controls_Types.Aileron_Trim_Position_Type;

   function Load
     (An_Instance : in Instance)
      return Electrical_Units_Types.Amps;


   procedure Update
     (An_Instance      : in out Instance;
      Iconst           : in     Float;
      Electrical_Power : in     Boolean;
      Switch_Left      : in     Boolean;
      Switch_Right     : in     Boolean;
      Trim_Interrupt   : in     Boolean;
      Trim_Disconnect  : in     Boolean;
      Trim_Fail_Malf   : in     Boolean;
      Roll_Right_Malf  : in     Boolean);

private

   type Instance is
      record
         Position : Jpats_Secondary_Flight_Controls_Types.Aileron_Trim_Position_Type;
         Load     : Electrical_Units_Types.Amps;
      end record;

end Aileron_Trim;

