-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Aileron_Trim is

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Position := 0.0;
      An_Instance.Load     := 0.0;
   exception
      when others =>
         Log.Report("Aileron_Trim.Initialize()");
         raise;
   end Initialize;

   procedure Set_Position
     (An_Instance : in out Instance;
      Iconst      : in     Float;
      Position    : in     Float)
   is
   begin
      An_Instance.Position := Position;
   exception
      when others =>
         Log.Report("Aileron_Trim.Set_Position()");
         raise;
   end Set_Position;

   function Position
     (An_Instance : in Instance)
     return Jpats_Secondary_Flight_Controls_Types.Aileron_Trim_Position_Type
   is
   begin
      return An_Instance.Position;
   exception
      when others =>
         Log.Report("Aileron_Trim.Position()");
         raise;
   end Position;

   function Load
     (An_Instance : in Instance)
     return Electrical_Units_Types.Amps
   is
   begin
      return An_Instance.Load;
   exception
      when others =>
         Log.Report("Aileron_Trim.Load()");
         raise;
   end Load;

   procedure Update
     (An_Instance      : in out Instance;
      Iconst           : in     Float;
      Electrical_Power : in     Boolean;
      Switch_Left      : in     Boolean;
      Switch_Right     : in     Boolean;
      Trim_Interrupt   : in     Boolean;
      Trim_Disconnect  : in     Boolean;
      Trim_Fail_Malf   : in     Boolean;
      Roll_Right_Malf  : in     Boolean)
   is

      package Sfc_T renames Jpats_Secondary_Flight_Controls_Types;

      Motion_Direction : Sfc_T.Aileron_Trim_Position_Type := 0.0;

      Old_Position : constant Sfc_T.Aileron_Trim_Position_Type := An_Instance.Position;

   begin

      if not Trim_Interrupt and not Trim_Disconnect and Electrical_Power then
         if Trim_Fail_Malf then
            null;
         elsif Roll_Right_Malf then
            Motion_Direction := -1.0;   -- right
         else
            if Switch_Left then
               Motion_Direction := 1.0;    -- left
            elsif Switch_Right then
               Motion_Direction := -1.0;   -- right
            end if;
         end if;
      end if;


      An_Instance.Position := (Sfc_T.Aileron_Trim_Position_Type'Max
                               (-1.0,Sfc_T.Aileron_Trim_Position_Type'Min
                                (1.0, Old_Position + 0.115 * Motion_Direction * Iconst)));

      if abs (An_Instance.Position - Old_Position) /= 0.0 then
         An_Instance.Load := 0.665;
      else
         An_Instance.Load := 0.0;
      end if;

   exception
      when others =>
         Log.Report("Aileron_Trim.Update()");
         raise;
   end Update;

end Aileron_Trim;

