-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Arinc_429_Types;
with Arinc_429_Bnr;
with Jpats_Engine_Data_Manager_Types;

package Scu is

   package Edm_T  renames Jpats_Engine_Data_Manager_Types;
   package A429_T renames Arinc_429_Types;


   -- n1 %
     package Label_302 is new Arinc_429_Bnr
    ( Label              => 8#302#,
      Value_Type         => Float,
      Scale              => 256.0,
      Significant_Digits => 14,
      Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
      Ssm_Type           => A429_T.Bnr_Ssm_Type,
      Discretes_Type     => A429_T.No_Discretes_Type);

   -- n1
   package Label_344 is new Arinc_429_Bnr
     ( Label              => 8#344#,
       Value_Type         => Float,
       Scale              => 256.0,
       Significant_Digits => 14,
       Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
       Ssm_Type           => A429_T.Bnr_Ssm_Type,
       Discretes_Type     => A429_T.No_Discretes_Type );

   -- oil pressure
   package Label_317 is new Arinc_429_Bnr
     ( Label              => 8#317#,
       Value_Type         => Float,
       Scale              => 256.0,
       Significant_Digits => 12,
       Sdi_Type           => Edm_T.Edm_Bnr_Sdi_Type,
       Ssm_Type           => A429_T.Bnr_Ssm_Type,
       Discretes_Type     => A429_T.No_Discretes_Type);


   type Instance is private;


   function Oil_Px_Warn_Signal
     (An_Instance : in Instance)
     return Boolean;

   function Oil_Px_Caut_Signal
     (An_Instance : in Instance)
     return Boolean;

   function Scu_Pwr
     (An_Instance : in Instance)
     return Boolean;

   function Scu_Oil_Px_Valid
     (An_Instance : in Instance)
     return Boolean;

   function Scu_N1_Valid
     (An_Instance : in Instance)
     return Boolean;

   function Scu_Oil_Px
     (An_Instance : in Instance)
     return Float;

   function Scu_N1
     (An_Instance : in Instance)
     return Float;

   function Scu_Edm_Oil_Px_A_Value
     (An_Instance : in Instance)
     return Float;

   function Scu_Edm_Oil_Px_B_Value
     (An_Instance : in Instance)
     return Float;

   function Scu_Edm_N1_A_Value
     (An_Instance : in Instance)
     return Float;

   function Scu_Edm_N1_B_Value
     (An_Instance : in Instance)
     return Float;

   function Scu_Oil_Px_Caut_Signal
     (An_Instance : in Instance)
     return Boolean;

   function Scu_Oil_Px_Warn_Signal
     (An_Instance : in Instance)
     return Boolean;

   function Scu_Edm_Oil_Px_A_Sdi
     (An_Instance : in Instance)
     return Integer;

   function Scu_Edm_Oil_Px_B_Sdi
     (An_Instance : in Instance)
     return Integer;

   function Scu_Edm_N1_A_Sdi
     (An_Instance : in Instance)
     return Integer;

   function Scu_Edm_N1_B_Sdi
     (An_Instance : in Instance)
     return Integer;

   function Scu_Edm_Oil_Px_A_Ssm
     (An_Instance : in Instance)
     return Integer;

   function Scu_Edm_Oil_Px_B_Ssm
     (An_Instance : in Instance)
     return Integer;

   function Scu_Edm_N1_A_Ssm
     (An_Instance : in Instance)
     return Integer;

   function Scu_Edm_N1_B_Ssm
     (An_Instance : in Instance)
     return Integer;


   procedure Update
     (An_Instance          : in out Instance;
      Iconst               : in     Float;
      Power                : in     Boolean;
      Edm_A429_A_Oil_Px    : in     A429_T.Message_Type;
      Edm_A429_B_Oil_Px    : in     A429_T.Message_Type;
      Edm_A429_A_N1        : in     A429_T.Message_Type;
      Edm_A429_B_N1        : in     A429_T.Message_Type);

   procedure Initialize
     (An_Instance : in out Instance);

private
   type Instance is
      record

         Edm_A429_A_Oil_Px_Value  : Float;
         Edm_A429_B_Oil_Px_Value  : Float;
         Edm_A429_A_N1_Value      : Float;
         Edm_A429_B_N1_Value      : Float;

         Edm_A429_A_Oil_Px_Sdi    : Edm_T.Edm_Bnr_Sdi_Type;
         Edm_A429_B_Oil_Px_Sdi    : Edm_T.Edm_Bnr_Sdi_Type;
         Edm_A429_A_N1_Sdi        : Edm_T.Edm_Bnr_Sdi_Type;
         Edm_A429_B_N1_Sdi        : Edm_T.Edm_Bnr_Sdi_Type;

         Edm_A429_A_Oil_Px_Ssm    : A429_T.Bnr_Ssm_Type;
         Edm_A429_B_Oil_Px_Ssm    : A429_T.Bnr_Ssm_Type;
         Edm_A429_A_N1_Ssm        : A429_T.Bnr_Ssm_Type;
         Edm_A429_B_N1_Ssm        : A429_T.Bnr_Ssm_Type;

         N1_Valid                 : Boolean;
         Oil_Px_Valid             : Boolean;

         Pwr                      : Boolean;
         N1                       : Float;
         Oil_Px                   : Float;
         Oil_Px_Caut_Signal       : Boolean;
         Oil_Px_Warn_Signal       : Boolean;
         Timer001                 : Float;
         Timer002                 : Float;
         Caut_Off_Latch           : Boolean;

      end record;

end Scu;
