-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Limit_G;
with Arinc_429_Types;
with Log;

use Arinc_429_Types;

package body Scu is

   No_Discretes : Arinc_429_Types.No_Discretes_Type;

   function Oil_Px_Warn_Signal
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Oil_Px_Warn_Signal;
   exception
      when others =>
         Log.Report("Scu.Oil_Px_Warn_Signal()");
         raise;
   end Oil_Px_Warn_Signal;

   function Oil_Px_Caut_Signal
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Oil_Px_Caut_Signal;
   exception
      when others =>
         Log.Report("Scu.Oil_Px_Caut_Signal()");
         raise;
   end Oil_Px_Caut_Signal;

   function Scu_Pwr
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Pwr;
   exception
      when others =>
         Log.Report("Scu.Scu_Pwr()");
         raise;
   end Scu_Pwr;

   function Scu_Oil_Px_Valid
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Oil_Px_Valid;
   exception
      when others =>
         Log.Report("Scu.Scu_Oil_Px_Valid()");
         raise;
   end Scu_Oil_Px_Valid;

   function Scu_N1_Valid
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.N1_Valid;
   exception
      when others =>
         Log.Report("Scu.Scu_N1_Valid()");
         raise;
   end Scu_N1_Valid;

   function Scu_Oil_Px
     (An_Instance : in Instance)
     return Float
   is
   begin
      return An_Instance.Oil_Px;
   exception
      when others =>
         Log.Report("Scu.Scu_Oil_Px()");
         raise;
   end Scu_Oil_Px;

   function Scu_N1
     (An_Instance : in Instance)
     return Float
   is
   begin
      return An_Instance.N1;
   exception
      when others =>
         Log.Report("Scu.Scu_N1()");
         raise;
   end Scu_N1;

   function Scu_Edm_Oil_Px_A_Value
     (An_Instance : in Instance)
     return Float
   is
   begin
      return An_Instance.Edm_A429_A_Oil_Px_Value;
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_Oil_Px_A_Value()");
         raise;
   end Scu_Edm_Oil_Px_A_Value;

   function Scu_Edm_Oil_Px_B_Value
     (An_Instance : in Instance)
     return Float
   is
   begin
      return An_Instance.Edm_A429_B_Oil_Px_Value;
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_Oil_Px_B_Value()");
         raise;
   end Scu_Edm_Oil_Px_B_Value;

   function Scu_Edm_N1_A_Value
     (An_Instance : in Instance)
     return Float
   is
   begin
      return An_Instance.Edm_A429_A_N1_Value;
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_N1_A_Value()");
         raise;
   end Scu_Edm_N1_A_Value;

   function Scu_Edm_N1_B_Value
     (An_Instance : in Instance)
     return Float
   is
   begin
      return An_Instance.Edm_A429_B_N1_Value;
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_N1_B_Value()");
         raise;
   end Scu_Edm_N1_B_Value;


   function Scu_Oil_Px_Caut_Signal
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Oil_Px_Caut_Signal;
   exception
      when others =>
         Log.Report("Scu.Scu_Oil_Px_Caut_Signal()");
         raise;
   end Scu_Oil_Px_Caut_Signal;

   function Scu_Oil_Px_Warn_Signal
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Oil_Px_Warn_Signal;
   exception
      when others =>
         Log.Report("Scu.Scu_Oil_Px_Warn_Signal()");
         raise;
   end Scu_Oil_Px_Warn_Signal;


   function Scu_Edm_Oil_Px_A_Sdi
     (An_Instance : in Instance)
     return Integer
   is
   begin
      return Edm_T.Edm_Bnr_Sdi_Type'Pos(An_Instance.Edm_A429_A_Oil_Px_Sdi);
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_Oil_Px_A_Sdi()");
         raise;
   end Scu_Edm_Oil_Px_A_Sdi;

   function Scu_Edm_Oil_Px_B_Sdi
     (An_Instance : in Instance)
     return Integer
   is
   begin
      return Edm_T.Edm_Bnr_Sdi_Type'Pos(An_Instance.Edm_A429_B_Oil_Px_Sdi);
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_Oil_Px_B_Sdi()");
         raise;
   end Scu_Edm_Oil_Px_B_Sdi;

   function Scu_Edm_N1_A_Sdi
     (An_Instance : in Instance)
     return Integer
   is
   begin
      return Edm_T.Edm_Bnr_Sdi_Type'Pos(An_Instance.Edm_A429_A_N1_Sdi);
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_N1_A_Sdi()");
         raise;
   end Scu_Edm_N1_A_Sdi;

   function Scu_Edm_N1_B_Sdi
     (An_Instance : in Instance)
     return Integer
   is
   begin
      return Edm_T.Edm_Bnr_Sdi_Type'Pos(An_Instance.Edm_A429_B_N1_Sdi);
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_N1_B_Sdi()");
         raise;
   end Scu_Edm_N1_B_Sdi;

   function Scu_Edm_Oil_Px_A_Ssm
     (An_Instance : in Instance)
     return Integer
   is
   begin
      return A429_T.Bnr_Ssm_Type'Pos(An_Instance.Edm_A429_A_Oil_Px_Ssm);
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_Oil_Px_A_Ssm()");
         raise;
   end Scu_Edm_Oil_Px_A_Ssm;

   function Scu_Edm_Oil_Px_B_Ssm
     (An_Instance : in Instance)
     return Integer
   is
   begin
      return A429_T.Bnr_Ssm_Type'Pos(An_Instance.Edm_A429_B_Oil_Px_Ssm);
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_Oil_Px_B_Ssm()");
         raise;
   end Scu_Edm_Oil_Px_B_Ssm;

   function Scu_Edm_N1_A_Ssm
     (An_Instance : in Instance)
     return Integer
   is
   begin
      return A429_T.Bnr_Ssm_Type'Pos(An_Instance.Edm_A429_A_N1_Ssm);
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_N1_A_Ssm()");
         raise;
   end Scu_Edm_N1_A_Ssm;

   function Scu_Edm_N1_B_Ssm
     (An_Instance : in Instance)
     return Integer
   is
   begin
      return A429_T.Bnr_Ssm_Type'Pos(An_Instance.Edm_A429_B_N1_Ssm);
   exception
      when others =>
         Log.Report("Scu.Scu_Edm_N1_B_Ssm()");
         raise;
   end Scu_Edm_N1_B_Ssm;



   subtype Float_0_5  is Float range 0.0..5.0;
   subtype Float_0_10 is Float range 0.0..10.0;
   function Flimit_0_5  is new Limit_G(Value_Type => Float, Limit_Type => Float_0_5);
   function Flimit_0_10 is new Limit_G(Value_Type => Float, Limit_Type => Float_0_10);


   procedure Update
     (An_Instance          : in out Instance;
      Iconst               : in     Float;
      Power                : in     Boolean;
      Edm_A429_A_Oil_Px    : in     Arinc_429_Types.Message_Type;
      Edm_A429_B_Oil_Px    : in     Arinc_429_Types.Message_Type;
      Edm_A429_A_N1        : in     Arinc_429_Types.Message_Type;
      Edm_A429_B_N1        : in     Arinc_429_Types.Message_Type)

   is

      Pwr                : Boolean renames An_Instance.Pwr;
      N1                 : Float   renames An_Instance.N1;
      Oil_Px             : Float   renames An_Instance.Oil_Px;
      Oil_Px_Caut_Signal : Boolean renames An_Instance.Oil_Px_Caut_Signal;
      Oil_Px_Warn_Signal : Boolean renames An_Instance.Oil_Px_Warn_Signal;
      Timer001           : Float   renames An_Instance.Timer001;
      Timer002           : Float   renames An_Instance.Timer002;
      Caut_Off_Latch     : Boolean renames An_Instance.Caut_Off_Latch;

      Edm_A429_A_Oil_Px_Value  : Float renames An_Instance.Edm_A429_A_Oil_Px_Value;
      Edm_A429_B_Oil_Px_Value  : Float renames An_Instance.Edm_A429_B_Oil_Px_Value;
      Edm_A429_A_N1_Value      : Float renames An_Instance.Edm_A429_A_N1_Value;
      Edm_A429_B_N1_Value      : Float renames An_Instance.Edm_A429_B_N1_Value;

      Edm_A429_A_Oil_Px_Sdi    : Edm_T.Edm_Bnr_Sdi_Type renames An_Instance.Edm_A429_A_Oil_Px_Sdi;
      Edm_A429_B_Oil_Px_Sdi    : Edm_T.Edm_Bnr_Sdi_Type renames An_Instance.Edm_A429_B_Oil_Px_Sdi;
      Edm_A429_A_N1_Sdi        : Edm_T.Edm_Bnr_Sdi_Type renames An_Instance.Edm_A429_A_N1_Sdi;
      Edm_A429_B_N1_Sdi        : Edm_T.Edm_Bnr_Sdi_Type renames An_Instance.Edm_A429_B_N1_Sdi;

      Edm_A429_A_Oil_Px_Ssm    : A429_T.Bnr_Ssm_Type renames An_Instance.Edm_A429_A_Oil_Px_Ssm;
      Edm_A429_B_Oil_Px_Ssm    : A429_T.Bnr_Ssm_Type renames An_Instance.Edm_A429_B_Oil_Px_Ssm;
      Edm_A429_A_N1_Ssm        : A429_T.Bnr_Ssm_Type renames An_Instance.Edm_A429_A_N1_Ssm;
      Edm_A429_B_N1_Ssm        : A429_T.Bnr_Ssm_Type renames An_Instance.Edm_A429_B_N1_Ssm;

      N1_Valid                 : Boolean renames An_Instance.N1_Valid;
      Oil_Px_Valid             : Boolean renames An_Instance.Oil_Px_Valid;

   begin


      --|
      --| ref: dwg no. 133-380161 rev 2
      --|


      Pwr := Power;



      if (Pwr) then



         Label_317.Unpack(A_Message         => Edm_A429_A_Oil_Px,
                          A_Value           => Edm_A429_A_Oil_Px_Value,
                          A_Sdi             => Edm_A429_A_Oil_Px_Sdi,
                          A_Ssm             => Edm_A429_A_Oil_Px_Ssm,
                          A_Discretes_Value => No_Discretes);

         Label_317.Unpack(A_Message         => Edm_A429_B_Oil_Px,
                          A_Value           => Edm_A429_B_Oil_Px_Value,
                          A_Sdi             => Edm_A429_B_Oil_Px_Sdi,
                          A_Ssm             => Edm_A429_B_Oil_Px_Ssm,
                          A_Discretes_Value => No_Discretes);

         Label_302.Unpack(A_Message         => Edm_A429_A_N1,
                          A_Value           => Edm_A429_A_N1_Value,
                          A_Sdi             => Edm_A429_A_N1_Sdi,
                          A_Ssm             => Edm_A429_A_N1_Ssm,
                          A_Discretes_Value => No_Discretes);

         Label_302.Unpack(A_Message         => Edm_A429_B_N1,
                          A_Value           => Edm_A429_B_N1_Value,
                          A_Sdi             => Edm_A429_B_N1_Sdi,
                          A_Ssm             => Edm_A429_B_N1_Ssm,
                          A_Discretes_Value => No_Discretes);


         if Edm_A429_A_Oil_Px_Ssm = A429_T.Normal then
            Oil_Px       := Edm_A429_A_Oil_Px_Value;
            Oil_Px_Valid := True;
         elsif Edm_A429_B_Oil_Px_Ssm = A429_T.Normal then
            Oil_Px       := Edm_A429_B_Oil_Px_Value;
            Oil_Px_Valid := True;
         else
            Oil_Px_Valid := False;
         end if;


         if Edm_A429_A_N1_Ssm = A429_T.Normal then
            N1       := Edm_A429_A_N1_Value;
            N1_Valid := True;
         elsif Edm_A429_B_N1_Ssm = A429_T.Normal then
            N1       := Edm_A429_B_N1_Value;
            N1_Valid := True;
         else
            N1_Valid := False;
         end if;


         if N1_Valid and Oil_Px_Valid then

            --| warn annunciator logic

            if N1 < 72.0 then

               if Oil_Px <= 15.0 then

                  Timer001           := 0.0;
                  Oil_Px_Warn_Signal := True;

               elsif Oil_Px > 15.0 and Oil_Px < 40.0 then

                  Timer001           := Flimit_0_5(Timer001 + Iconst);
                  Oil_Px_Warn_Signal := Timer001 >= 5.0;

               else

                  Timer001           := 0.0;
                  Oil_Px_Warn_Signal := False;

               end if;


            else  -- N1 >= 72.0

               Timer001            := 0.0;
               Oil_Px_Warn_Signal  := Oil_Px <= 40.0;

            end if;



            --| caution annunciator logic

            if N1 < 72.0 then

               Timer002 := 0.0;

               if N1 <= 10.0 and Oil_Px <= 10.0 then

                  Caut_Off_Latch := True;

               elsif N1 >= 30.0 and Oil_Px > 40.0 then

                  Caut_Off_Latch := False;

               end if;

               Oil_Px_Caut_Signal  := (Oil_Px > 15.0 and
                                         Oil_Px < 40.0 and
                                         not Caut_Off_Latch);

            else -- N1 >= 72.0

               if Oil_Px > 40.0 then

                  Caut_Off_Latch     := False;

               end if;


               if Oil_Px > 40.0 and Oil_Px < 90.0 then

                  Timer002           := Flimit_0_10(Timer002 + Iconst);
                  Oil_Px_Caut_Signal := Timer002 >= 10.0;

               else

                  Timer002           := 0.0;
                  Oil_Px_Caut_Signal := False;

               end if;

            end if;

         else -- invalid n1 and/or oil px from edm

            Timer001            := 0.0;
            Oil_Px_Warn_Signal  := True;
            Timer002            := 0.0;
            Oil_Px_Caut_Signal  := True;
            Caut_Off_Latch      := False;

         end if;

      else -- no pwr

         Timer001            := 0.0;
         Oil_Px_Warn_Signal  := True;
         Timer002            := 0.0;
         Oil_Px_Caut_Signal  := True;
         Caut_Off_Latch      := False;

      end if;

   exception
      when others =>
         Log.Report("Scu.Update()");
         raise;
   end Update;


   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin

      An_Instance.Edm_A429_A_Oil_Px_Value  := 0.0;
      An_Instance.Edm_A429_B_Oil_Px_Value  := 0.0;
      An_Instance.Edm_A429_A_N1_Value      := 0.0;
      An_Instance.Edm_A429_B_N1_Value      := 0.0;

      An_Instance.Edm_A429_A_Oil_Px_Sdi    := Edm_T.Channel_A;
      An_Instance.Edm_A429_B_Oil_Px_Sdi    := Edm_T.Channel_B;
      An_Instance.Edm_A429_A_N1_Sdi        := Edm_T.Channel_A;
      An_Instance.Edm_A429_B_N1_Sdi        := Edm_T.Channel_B;

      An_Instance.Edm_A429_A_Oil_Px_Ssm    := A429_T.Normal;
      An_Instance.Edm_A429_B_Oil_Px_Ssm    := A429_T.Normal;
      An_Instance.Edm_A429_A_N1_Ssm        := A429_T.Normal;
      An_Instance.Edm_A429_B_N1_Ssm        := A429_T.Normal;

      An_Instance.N1_Valid                 := False;
      An_Instance.Oil_Px_Valid             := False;

      An_Instance.Pwr                      := False;
      An_Instance.N1                       := 0.0;
      An_Instance.Oil_Px                   := 0.0;
      An_Instance.Oil_Px_Caut_Signal       := False;
      An_Instance.Oil_Px_Warn_Signal       := False;
      An_Instance.Timer001                 := 0.0;
      An_Instance.Timer002                 := 0.0;
      An_Instance.Caut_Off_Latch           := True;

   exception
      when others =>
         Log.Report("Scu.Initialize()");
         raise;
   end Initialize;




end Scu;
