-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Jpats_Scu.Container;
with Scu;
with Log;


package body Jpats_Scu is

   package Ctnr renames Container;
   The_Scu : Scu.Instance renames Ctnr.This_Subsystem.The_Scu;

   function Oil_Px_Warn_Request
     return Boolean is
   begin
      return Scu.Oil_Px_Warn_Signal(The_Scu);
   exception
      when others =>
         Log.Report("Jpats_Scu.Oil_Px_Warn_Request()");
         raise;
   end Oil_Px_Warn_Request;


   function Oil_Px_Caution_Request
     return Boolean is
   begin
      return Scu.Oil_Px_Caut_Signal(The_Scu);
   exception
      when others =>
         Log.Report("Jpats_Scu.Oil_Px_Caution_Request()");
         raise;
   end Oil_Px_Caution_Request;


end Jpats_Scu;
