-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Scu.Container;
with Jpats_Ios_Interface;
with Log;

package body Jpats_Scu.Ios_Interface is

   package Ctnr renames Container;
   package JII renames Jpats_Ios_Interface;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   Io  : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;


   procedure Register_Ios_Variables is
   begin


      Jpats_Ios_Interface.Register
        (Name      => "Scu_Pwr",
         Variable  => Ios.Scu_Pwr'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Oil_Px_Valid",
         Variable  => Ios.Scu_Oil_Px_Valid'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_N1_Valid",
         Variable  => Ios.Scu_N1_Valid'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Oil_Px",
         Variable  => Ios.Scu_Oil_Px'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_N1",
         Variable  => Ios.Scu_N1'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_Oil_Px_A_Value",
         Variable  => Ios.Scu_Edm_Oil_Px_A_Value'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_Oil_Px_B_Value",
         Variable  => Ios.Scu_Edm_Oil_Px_B_Value'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_N1_A_Value",
         Variable  => Ios.Scu_Edm_N1_A_Value'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_N1_B_Value",
         Variable  => Ios.Scu_Edm_N1_B_Value'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Oil_Px_Caut_Signal",
         Variable  => Ios.Scu_Oil_Px_Caut_Signal'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Oil_Px_Warn_Signal",
         Variable  => Ios.Scu_Oil_Px_Warn_Signal'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_Oil_Px_A_Sdi",
         Variable  => Ios.Scu_Edm_Oil_Px_A_Sdi'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_Oil_Px_B_Sdi",
         Variable  => Ios.Scu_Edm_Oil_Px_B_Sdi'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_N1_A_Sdi",
         Variable  => Ios.Scu_Edm_N1_A_Sdi'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_N1_B_Sdi",
         Variable  => Ios.Scu_Edm_N1_B_Sdi'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_Oil_Px_A_Ssm",
         Variable  => Ios.Scu_Edm_Oil_Px_A_Ssm'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_Oil_Px_B_Ssm",
         Variable  => Ios.Scu_Edm_Oil_Px_B_Ssm'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_N1_A_Ssm",
         Variable  => Ios.Scu_Edm_N1_A_Ssm'Address
        );

      Jpats_Ios_Interface.Register
        (Name      => "Scu_Edm_N1_B_Ssm",
         Variable  => Ios.Scu_Edm_N1_B_Ssm'Address
        );



      null;
   exception
      when others =>
         Log.Report("Jpats_Scu.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;

end Jpats_Scu.Ios_Interface;

