-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Scu.Container;
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Engine_Data_Manager;
with Scu;
with Arinc_429_Types;
with Log;

package body Jpats_Scu.Controller is

   package Ctnr  renames Jpats_Scu.Container;
   package Ele   renames Jpats_Electrical;
   package Ele_T renames Jpats_Electrical_Types;
   package Edm   renames Jpats_Engine_Data_Manager;
   The_Scu : Scu.Instance renames Ctnr.This_Subsystem.The_Scu;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;

   procedure Initialize is
   begin

      Scu.Initialize(The_Scu);

      null;
   exception
      when others =>
         Log.Report("Jpats_Scu.Controller.Initialize()");
         raise;
   end Initialize;


   procedure Update
     (Iconst : in Float) is

      Edm_A_Oil_Px : constant Arinc_429_Types.Message_Type := Edm.A429_TX_EDM_A_317_Oil_Pressure;
      Edm_B_Oil_px : constant Arinc_429_Types.Message_Type := Edm.A429_TX_EDM_B_317_Oil_Pressure;
      Edm_A_N1     : constant Arinc_429_Types.Message_Type := Edm.A429_TX_EDM_A_302_N1;
      Edm_B_N1     : constant Arinc_429_Types.Message_Type := Edm.A429_TX_EDM_B_302_N1;
      Scu_Pwr      : constant Boolean := (Ele.Is_Powered(Ele_T.Edm_Cb_Fwd_Batt_Bus) or
                                            Ele.Is_Powered(Ele_T.Edm_Cb_Fwd_Gen_Bus));

   begin

      Scu.Update
        (An_Instance         => The_Scu,
         Iconst              => Iconst,
         Power               => Scu_Pwr,
         Edm_A429_A_Oil_Px   => Edm_A_Oil_Px,
         Edm_A429_B_Oil_Px   => Edm_B_Oil_px,
         Edm_A429_A_N1       => Edm_A_N1,
         Edm_A429_B_N1       => Edm_B_N1);


         Ios.Scu_Pwr                   := Scu.Scu_Pwr                  (An_Instance => The_Scu);
         Ios.Scu_Oil_Px_Valid          := Scu.Scu_Oil_Px_Valid         (An_Instance => The_Scu);
         Ios.Scu_N1_Valid              := Scu.Scu_N1_Valid             (An_Instance => The_Scu);
         Ios.Scu_Oil_Px                := Scu.Scu_Oil_Px               (An_Instance => The_Scu);
         Ios.Scu_N1                    := Scu.Scu_N1                   (An_Instance => The_Scu);
         Ios.Scu_Edm_Oil_Px_A_Value    := Scu.Scu_Edm_Oil_Px_A_Value   (An_Instance => The_Scu);
         Ios.Scu_Edm_Oil_Px_B_Value    := Scu.Scu_Edm_Oil_Px_B_Value   (An_Instance => The_Scu);
         Ios.Scu_Edm_N1_A_Value        := Scu.Scu_Edm_N1_A_Value       (An_Instance => The_Scu);
         Ios.Scu_Edm_N1_B_Value        := Scu.Scu_Edm_N1_B_Value       (An_Instance => The_Scu);
         Ios.Scu_Oil_Px_Caut_Signal    := Scu.Scu_Oil_Px_Caut_Signal   (An_Instance => The_Scu);
         Ios.Scu_Oil_Px_Warn_Signal    := Scu.Scu_Oil_Px_Warn_Signal   (An_Instance => The_Scu);
         Ios.Scu_Edm_Oil_Px_A_Sdi      := Scu.Scu_Edm_Oil_Px_A_Sdi     (An_Instance => The_Scu);
         Ios.Scu_Edm_Oil_Px_B_Sdi      := Scu.Scu_Edm_Oil_Px_B_Sdi     (An_Instance => The_Scu);
         Ios.Scu_Edm_N1_A_Sdi          := Scu.Scu_Edm_N1_A_Sdi         (An_Instance => The_Scu);
         Ios.Scu_Edm_N1_B_Sdi          := Scu.Scu_Edm_N1_B_Sdi         (An_Instance => The_Scu);
         Ios.Scu_Edm_Oil_Px_A_Ssm      := Scu.Scu_Edm_Oil_Px_A_Ssm     (An_Instance => The_Scu);
         Ios.Scu_Edm_Oil_Px_B_Ssm      := Scu.Scu_Edm_Oil_Px_B_Ssm     (An_Instance => The_Scu);
         Ios.Scu_Edm_N1_A_Ssm          := Scu.Scu_Edm_N1_A_Ssm         (An_Instance => The_Scu);
         Ios.Scu_Edm_N1_B_Ssm          := Scu.Scu_Edm_N1_B_Ssm         (An_Instance => The_Scu);

   exception
      when others =>
         Log.Report("Jpats_Scu.Controller.Update()");
         raise;
   end Update;


end Jpats_Scu.Controller;
