-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Scu;


private package Jpats_Scu.Container is



   type Instance is
      record

         The_Scu : Scu.Instance;

      end record;
   This_Subsystem : Instance;



   Io_Size : constant Integer := 4;

   type Io_Interface_Instance is
      record
         null;
      end record;


--     for Io_Interface_Instance use
--        record
--           null;
--        end record;
   This_Io_Interface : Io_Interface_Instance;


   type Ios_Interface_Instance is
      record

         Scu_Pwr                   : Boolean := False;
         Scu_Oil_Px_Valid          : Boolean := False;
         Scu_N1_Valid              : Boolean := False;
         Scu_Oil_Px                : Float   := 0.0;
         Scu_N1                    : Float   := 0.0;
         Scu_Edm_Oil_Px_A_Value    : Float   := 0.0;
         Scu_Edm_Oil_Px_B_Value    : Float   := 0.0;
         Scu_Edm_N1_A_Value        : Float   := 0.0;
         Scu_Edm_N1_B_Value        : Float   := 0.0;
         Scu_Oil_Px_Caut_Signal    : Boolean := False;
         Scu_Oil_Px_Warn_Signal    : Boolean := False;

         Scu_Edm_Oil_Px_A_Sdi      : Integer := 0;
         Scu_Edm_Oil_Px_B_Sdi      : Integer := 0;
         Scu_Edm_N1_A_Sdi          : Integer := 0;
         Scu_Edm_N1_B_Sdi          : Integer := 0;

         Scu_Edm_Oil_Px_A_Ssm      : Integer := 0;
         Scu_Edm_Oil_Px_B_Ssm      : Integer := 0;
         Scu_Edm_N1_A_Ssm          : Integer := 0;
         Scu_Edm_N1_B_Ssm          : Integer := 0;


      end record;
   This_Ios_Interface : Ios_Interface_Instance;


end Jpats_Scu.Container;
