-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Ordered_Tuple;
package Vector_Types is

   type Cartesian_Index_Type is (X, Y, Z);

   package Cartesian_Vector is new
     Ordered_Tuple
     ( Index => Cartesian_Index_Type,
       Float_Type => Float );

   package Cartesian_Long_Vector is new
     Ordered_Tuple
     ( Index => Cartesian_Index_Type,
       Float_Type => Long_Float );

   package Load_Factor_Vector is new
     Ordered_Tuple
     ( Index => Cartesian_Index_Type,
       Float_Type => Float );

   type Earth_Position_Index_Type is
      (North, East, Height);

   package Earth_Position_Vector is new
     Ordered_Tuple
     ( Index => Earth_Position_Index_Type,
       Float_Type => Float );

   subtype Quaternion_Index_Type is Positive range 1..4;

   package Quaternion is new
     Ordered_Tuple
     ( Index => Quaternion_Index_Type,
       Float_Type => Float );

   type Euler_Angle_Index_Type is (Roll, Pitch, Yaw);
   -- Roll  - rotation about X axis (phi)
   -- Pitch - rotation about Y axis (theta)
   -- Yaw   - rotation about Z axis (psi)

   package Euler_Angle_Rotation is new
     Ordered_Tuple
     ( Index => Euler_Angle_Index_Type,
       Float_Type => Float );

   type Reference_System_Index_Type is
      ( Fuselage_Station, Buttline, Waterline );

   package Reference_System_Vector is new
     Ordered_Tuple
     ( Index => Reference_System_Index_Type,
       Float_Type => Float );

end Vector_Types;
