-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


package body Vector_Types.Cross_Products is

   -- Cross products

   function "*"
     ( A, B : in Cartesian_Vector.Instance )
     return Cartesian_Vector.Instance is

   begin

      return
        ( X => A(Y) * B(Z) - A(Z) * B(Y),
          Y => A(Z) * B(X) - A(X) * B(Z),
          Z => A(X) * B(Y) - A(Y) * B(X) );

   end "*";

   function "*"
     ( A, B : in Euler_Angle_Rotation.Instance )
     return Euler_Angle_Rotation.Instance is

   begin

      return
        ( Roll  => A(Pitch) * B(Yaw) - A(Yaw) * B(Pitch),
          Pitch => A(Yaw) * B(Roll) - A(Roll) * B(Yaw),
          Yaw   => A(Roll) * B(Pitch) - A(Pitch) * B(Roll) );

   end "*";

   function "*"
     ( A : in Euler_Angle_Rotation.Instance;
       B : in Cartesian_Vector.Instance)
     return Cartesian_Vector.Instance is

   begin

      return
        ( X => A(Pitch) * B(Z) - A(Yaw) * B(Y),
          Y => A(Yaw) * B(X)   - A(Roll) * B(Z),
          Z => A(Roll) * B(Y)  - A(Pitch) * B(X) );

   end "*";

   function "*"
     ( A : in Cartesian_Vector.Instance;
       B : in Euler_Angle_Rotation.Instance)
     return Cartesian_Vector.Instance is

   begin

      return
        ( X => A(Y) * B(Yaw)   - A(Z) * B(Pitch),
          Y => A(Z) * B(Roll)  - A(X) * B(Yaw),
          Z => A(X) * B(Pitch) - A(Y) * B(Roll) );

   end "*";

end Vector_Types.Cross_Products;
