with Coordinate_Types;
package body Vector_Types.Coordinate_Types_Conversions is

    -- Conversion functions between Coordinate_Types and Vector_Types

    function Convert
      ( C : in Coordinate_Types.Cartesian )
       return Vector_Types.Cartesian_Vector.Instance is
    begin
       return ( X => C.X,
                Y => C.Y,
                Z => C.Z );
    end Convert;

    function Convert
      ( C : in Coordinate_Types.Cartesian )
       return Vector_Types.Load_Factor_Vector.Instance is
    begin
       return ( X => C.X,
                Y => C.Y,
                Z => C.Z );
    end Convert;

    function Convert
      ( C : in Coordinate_Types.Attitude )
       return Vector_Types.Euler_Angle_Rotation.Instance is
    begin
       return ( Roll  => C.Roll,
                Pitch => C.Pitch,
                Yaw   => C.Yaw );
    end Convert;

end Vector_Types.Coordinate_Types_Conversions;
