-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


package body Vector_Types.Conversions is

   -- Performs sign conversions between 3-D vector types
   -- Does not scale units (e.g. from feet to inches)

   function Convert_To_Reference_System
     ( CV : in Cartesian_Vector.Instance )
      return Reference_System_Vector.Instance is
   begin
      return
        ( Fuselage_Station => - Cv(X),   -- FS is positive aft of reference point
          Buttline         =>   Cv(Y),   -- BL is positive starboard of reference point
          Waterline        => - Cv(Z) ); -- WL is positive above reference point
   end Convert_To_Reference_System;


   function Convert_To_Load_Factor
     ( CV : in Cartesian_Vector.Instance )
      return Load_Factor_Vector.Instance is
   begin
      return
        ( X =>   Cv(X),
          Y =>   Cv(Y),
          Z => - Cv(Z) );
   end Convert_To_Load_Factor;

   function Convert_To_Earth_Position
     ( CV : in Cartesian_Vector.Instance )
      return Earth_Position_Vector.Instance is
   begin
      return
        ( North  =>   Cv(X),
          East   =>   Cv(Y),
          Height => - Cv(Z) );
   end Convert_To_Earth_Position;

   function Convert_To_Cartesian
     ( RS : in Reference_System_Vector.Instance )
     return Cartesian_Vector.Instance is
   begin
      return
        ( X => - Rs(Fuselage_Station),
          Y =>   Rs(Buttline),
          Z => - Rs(Waterline) );
   end Convert_To_Cartesian;

   function Convert_To_Cartesian
     ( LF : in Load_Factor_Vector.Instance )
     return Cartesian_Vector.Instance is
   begin
      return
        ( X =>   LF(X),
          Y =>   LF(Y),
          Z => - LF(Z));
   end Convert_To_Cartesian;

   function Convert_To_Cartesian
     ( EP : in Earth_Position_Vector.Instance )
     return Cartesian_Vector.Instance is
   begin
      return
        ( X =>   Ep(North),
          Y =>   Ep(East),
          Z => - Ep(Height) );
   end Convert_To_Cartesian;

end Vector_Types.Conversions;
