-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-- This package implements a uniform random number generator.  It is a
-- generalization of the functionality in the function unif_rand in FSI SSD
-- module F111 (Motion Special Effects).  A new generator is created by
-- instantiating the package with the modulus, multiplier, and increment.
-- For a desired modulus M, define an integer modulo type, and use the type
-- to instantiate this package.  E.g.,
--
--     type My_Seed_Type is mod M;
--     package My_Generator is new
--        Uniform_Random_Number_Generator_G
--        ( Seed_Type => My_Seed_Type,
--          ...
--          ... );

generic
   type Seed_Type is mod <>;     -- modulus is M
   Initial_Seed : in Seed_Type;
   Multiplier   : in Seed_Type;  -- A
   Increment    : in Seed_Type;  -- C
package Uniform_Random_Number_Generator_G is

   subtype Random_Number_Type is
     Float range 0.0 .. 1.0;

   function Random_Number
     return Random_Number_Type;

end Uniform_Random_Number_Generator_G;

