-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-- This package implements a uniform random number generator.  It is a
-- generalization of the functionality in the function unif_rand in FSI SSD
-- module F111 (Motion Special Effects).  A new generator is created by
-- instantiating the package with the modulus, multiplier, and increment.

package body Uniform_Random_Number_Generator_G is

   -- Maintain the seed for the generator as a static variable
   Seed : Seed_Type := Initial_Seed;

   function Random_Number
     return Random_Number_Type is
   begin

      -- This implements the linear congruential random number generator
      -- X(N+1) = (A * X(N) + C) mod M

      -- Because all of the following variables are of a modulus integer type
      -- there is no need for an explicit modulus operation.

      Seed := Multiplier * Seed + Increment;
      return Float(Seed) / Float(Seed_Type'Modulus);

   end Random_Number;


end Uniform_Random_Number_Generator_G;
