generic

   Max_Variables : Positive;

package Time_History_G is

   subtype Variable_Index_Type is
     Positive range 1 .. Max_Variables;

   type Variable_Index_Array is array
     ( Variable_Index_Type ) of Integer;

   type Value_Array is array
     ( Variable_Index_Type ) of Float;

   type Handle is private;

   procedure Open_Input_File
     ( A_Filename : in String;
       A_Handle : out Handle;
       A_Variable_Count : out Integer;
       A_Variable_Index_Array : out Variable_Index_Array );

   procedure Read_Input_Line
     ( A_Handle : in Handle;
       A_Value_Array : out Value_Array;
       No_More_Rows : out Boolean );

   procedure Close_Input_File
     ( A_Handle : in Handle );

private

   type Instance;
   type Handle is access Instance;

end Time_History_G;

