--
--            FlightSafety International Simulation Systems Division
--                     Broken Arrow, OK  USA  918-259-4000
--
--                  JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Ted Dennison
--
--  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--  technical or operational data or information from automatic dissemination
--  under the International Exchange Program or by other means.  This protection
--  covers information required solely for administrative or operational
--  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
--  WARNING:  This document contains technical data whose export is restricted
--  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--  Executive Order 12470.  Violation of these export control laws is subject
--  to severe criminal penalties.  Dissemination of this document is controlled
--  under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Interfaces.C;
with Interfaces.C.Strings;

use type Interfaces.C.Int;
use type Interfaces.C.Size_T;

-------------------------------------------------------------------------------
-- This package implements an Ada interface to the Stethescope real-time data
-- monitor. The current version supported by this package is 5.1
-------------------------------------------------------------------------------
package body Stethoscope is

   ----------------------------------------------------------------------------
   -- Register an object at the given address with the signal manager.
   ----------------------------------------------------------------------------
   procedure Register_Signal
     (Name           : in String;
      Units          : in String;
      Object_Address : in System.Address;
      Value_Type     : in String;
      Scope_Index    : in Stethoscope_Index := Default_Scope_Index) is

   begin
      return;
   end Register_Signal;


   ----------------------------------------------------------------------------
   -- Register an object at the given offset from the given address with
   -- the signal manager.
   -- Note that the Object_Address must be the address of *the*address* of
   -- the object from which the ofset will be calculated.
   ----------------------------------------------------------------------------
   procedure Register_Signal_With_Offset
     (Name           : in String;
      Units          : in String;
      Object_Address : in System.Address;
      Value_Type     : in String;
      Offset         : in Integer := 0;
      Scope_Index    : in Stethoscope_Index := Default_Scope_Index) is

   begin
      return;
   end Register_Signal_With_Offset;


   ----------------------------------------------------------------------------
   -- Install an object at the given offset from the given address with
   -- Stethescope.
   ----------------------------------------------------------------------------
   procedure Install_Signal
     (Name           : in String;
      Units          : in String;
      Object_Address : in System.Address;
      Value_Type     : in String;
      Offset         : in Integer := 0;
      Scope_Index    : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Install_Signal;

   ----------------------------------------------------------------------------
   -- Activate the given signal.
   ----------------------------------------------------------------------------
   procedure Activate_Signal
     (Name        : in String;
      Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Activate_Signal;

   ----------------------------------------------------------------------------
   -- Deactivate the given signal.
   ----------------------------------------------------------------------------
   procedure Deactivate_Signal
     (Name        : in String;
      Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Deactivate_Signal;

   ----------------------------------------------------------------------------
   -- Return the scopes maximum samples.
   ----------------------------------------------------------------------------
   function Max_Samples (Scope_Index : in Stethoscope_Index := Default_Scope_Index)
     return Integer is
   begin
      return 30;
   end Max_Samples;

   ----------------------------------------------------------------------------
   -- Remove the given signal.
   ----------------------------------------------------------------------------
   procedure Remove_Signal
     (Name        : in String;
      Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Remove_Signal;

   ----------------------------------------------------------------------------
   -- Remove all signals whose names start with the given prefix
   ----------------------------------------------------------------------------
   procedure Remove_Signals
     (Name_Prefix : in String;
      Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Remove_Signals;

   ----------------------------------------------------------------------------
   -- Show all the signals.
   ----------------------------------------------------------------------------
   procedure Show_Signals (Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Show_Signals;


   ----------------------------------------------------------------------------
   -- Show all the signals that are being collected.
   ----------------------------------------------------------------------------
   procedure Show_Active_Signals (Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Show_Active_Signals;


   ----------------------------------------------------------------------------
   -- Get the sampling rate parameters
   ----------------------------------------------------------------------------
   procedure Sampling_Rate_Parameters
     (Sample_Divisor    :    out Integer;
      Number_Of_Samples :    out Integer;
      Scope_Index       : in     Stethoscope_Index := Default_Scope_Index) is

      Divisor : aliased Interfaces.C.Int := -1;
      Number  : aliased Interfaces.C.Int := -1;
   begin
      return;
   end Sampling_Rate_Parameters;

   ----------------------------------------------------------------------------
   -- Set the sampling rate parameters
   ----------------------------------------------------------------------------
   procedure Set_Sampling_Rate_Parameters
     (Sample_Divisor    : in Positive;
      Number_Of_Samples : in Positive;
      Scope_Index       : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Set_Sampling_Rate_Parameters;

   ----------------------------------------------------------------------------
   -- Collect Signals.
   ----------------------------------------------------------------------------
   procedure Collect_Signals (Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Collect_Signals;

   ----------------------------------------------------------------------------
   -- Change the sample rate to the given (Hz) value
   ----------------------------------------------------------------------------
   procedure Change_Sample_Rate
     (New_Sample_Rate : in Long_Float;
      Scope_Index     : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Change_Sample_Rate;

   ----------------------------------------------------------------------------
   -- Set the trigger on a signal to the given level and slope.
   ----------------------------------------------------------------------------
   procedure Set_Trigger
     (Source       : in String;
      Level        : in Long_Float;
      Slope        : in Integer;
      Delay_Amount : in Float;
      Hold_Off     : in Float;
      Scope_Index  : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Set_Trigger;

   ----------------------------------------------------------------------------
   -- Get the current trigger arguments.
   ----------------------------------------------------------------------------
   procedure Get_Trigger
     (Source       :    out String;
      Source_Size  :    out Natural;
      Level        :    out Long_Float;
      Slope        :    out Integer;
      Delay_Amount :    out Float;
      Hold_Off     :    out Float;
      Armed        :    out Boolean;
      Scope_Index  : in     Stethoscope_Index := Default_Scope_Index) is

   begin
      -- Assign the C values back to the Ada output variables
      Source_Size := 0;
      Source (Source'First..Source'First + Source_Size - 1) := "";
      Level        := 0.0;
      Slope        := Integer'First;
      Delay_Amount := 0.0;
      Hold_Off     := 0.0;
      Armed        := Boolean'First;
   end Get_Trigger;

   ----------------------------------------------------------------------------
   -- Send a script to stethescope
   ----------------------------------------------------------------------------
   procedure Send_Script
     (Script      : in String;
      Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Send_Script;

   ----------------------------------------------------------------------------
   -- Clear any scripts
   ----------------------------------------------------------------------------
   procedure Clear_Script (Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Clear_Script;

   ----------------------------------------------------------------------------
   -- Put an annontation on the scope display at the given coordinates.
   ----------------------------------------------------------------------------
   procedure Send_Annotation
     (X_Coordinate : in Long_Float;
      Y_Coordinate : in Long_Float;
      Text         : in String;
      Scope_Index  : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Send_Annotation;

   ----------------------------------------------------------------------------
   -- Clear an annotation
   ----------------------------------------------------------------------------
   procedure Clear_Annotation (Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Clear_Annotation;

   ----------------------------------------------------------------------------
   -- Print the version string.
   ----------------------------------------------------------------------------
   procedure Print_Version is
   begin
      return;
   end Print_Version;

   ----------------------------------------------------------------------------
   -- Initialize the stethescope server with the given buffer size and debug
   -- level.
   ----------------------------------------------------------------------------
   procedure Initialize_Server
     (Data_Buffer_Size   : in Natural := Default_Buffer_Size;
      Signal_Buffer_Size : in Natural := Default_Buffer_Size;
      Debug_Level        : in Debugging_Level := Error_Status;
      Probe_Priority     : in Natural := Default_Priority;
      Link_Priority      : in Natural := Default_Priority;
      Scope_Index        : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Initialize_Server;

   ----------------------------------------------------------------------------
   -- Start up the stethescope real-time daemons with the given buffer sizes,
   -- daemon priorities, and and debug level using any available Index.
   ----------------------------------------------------------------------------
   procedure Initialize_Any_Server
     (Data_Buffer_Size   : in      Natural := Default_Buffer_Size;
      Signal_Buffer_Size : in      Natural := Default_Buffer_Size;
      Debug_Level        : in      Debugging_Level := Error_Status;
      Probe_Priority     : in      Natural := Default_Priority;
      Link_Priority      : in      Natural := Default_Priority;
      Scope_Index        :     out Stethoscope_Index) is
      Result : Interfaces.C.Int;
   begin
      Scope_Index := Stethoscope_Index'First;
   end Initialize_Any_Server;


   ----------------------------------------------------------------------------
   -- Set the data collection mode.
   ----------------------------------------------------------------------------
   procedure Set_Collection_Mode
     (Mode        : in Collection_Mode;
      Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Set_Collection_Mode;

   ----------------------------------------------------------------------------
   -- Shut down the scope with the given index.
   ----------------------------------------------------------------------------
   procedure Shutdown (Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Shutdown;

   ----------------------------------------------------------------------------
   -- Set the callback function for variable expression requests.
   ----------------------------------------------------------------------------
   procedure Set_Variable_Expression_Address_Find_Callback
     (Callback    : in Variable_Address_Find;
      User_Data   : in System.Address;
      Scope_Index : in Stethoscope_Index := Default_Scope_Index) is
   begin
      return;
   end Set_Variable_Expression_Address_Find_Callback;

end Stethoscope;
