-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Temperature_Types is

   function Celsius_To_Fahrenheit
     (T : in Celsius)
      return Fahrenheit is
   begin
      return 1.8 * (T + 40.0) - 40.0;
   end Celsius_To_Fahrenheit;

   function Celsius_To_Kelvin
     (T : in Celsius)
      return Kelvin is
   begin
      return T + 273.15;
   end Celsius_To_Kelvin;

   function Celsius_To_Rankine
     (T : in Celsius)
      return Rankine is
   begin
      return Celsius_To_Fahrenheit (T) + 459.67;
   end Celsius_To_Rankine;


   function Fahrenheit_To_Celsius
     (T : in Fahrenheit)
      return Celsius is
   begin
      return 5.5555e-1 * (T + 40.0) - 40.0;
   end Fahrenheit_To_Celsius;

   function Fahrenheit_To_Kelvin
     (T : in Fahrenheit)
      return Kelvin is
   begin
      return Fahrenheit_To_Celsius (T) + 273.15;
   end Fahrenheit_To_Kelvin;

   function Fahrenheit_To_Rankine
     (T : in Fahrenheit)
      return Rankine is
   begin
      return T + 459.67;
   end Fahrenheit_To_Rankine;


   function Kelvin_To_Celsius
     (T : in Kelvin)
      return Celsius is
   begin
      return T - 273.15;
   end Kelvin_To_Celsius;

   function Kelvin_To_Fahrenheit
     (T : in Kelvin)
      return Fahrenheit is
   begin
      return  Celsius_To_Fahrenheit (Kelvin_To_Celsius (T));
   end Kelvin_To_Fahrenheit;

   function Kelvin_To_Rankine
     (T : in Kelvin)
      return Rankine is
   begin
      return Kelvin_To_Fahrenheit (T) + 459.67;
   end Kelvin_To_Rankine;



   function Rankine_To_Fahrenheit
     (T : in Rankine)
      return Fahrenheit is
   begin
      return T - 459.67;
   end Rankine_To_Fahrenheit;

   function Rankine_To_Celsius
     (T : in Rankine)
      return  Celsius is
   begin
      return Fahrenheit_To_Celsius (Rankine_To_Fahrenheit (T));
   end Rankine_To_Celsius;

   function Rankine_To_Kelvin
     (T : in Rankine)
      return Kelvin is
   begin
      return Rankine_To_Celsius (T) + 273.15;
   end Rankine_To_Kelvin;


end Temperature_Types;
