-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- This package provides a dictionary-style lookup of "definitions" of strings
-- based on lines at the end of the sim.cfg file.
--
-- The lines in the sim.cfg file should contain an identifer followed by an
-- equals sign and a quotation-delimited string or integer. eg:
--   Fred_File_Path = "master/subdir/"
--   Joe_File_Name = "joe.txt"
--   Foo_Size      = 3
--
-- Given the above entries, a lookup of the string "Joe_File_Name" should return
-- the string "joe.txt"
--------------------------------------------------------------------------------
package Simulation_Dictionary is

   Undefined_Word : exception;

   -----------------------------------------------------------------------------
   -- Lookup the given word in the dictionary, and return its definition. Note
   -- that the lookup is cached, so that subsequent lookups for the same word
   -- won't take as long.
   --
   -- Undefined_Word will be raised if the given word has no definition. In
   -- order to prevent this, you can give the word a default definition with
   -- the Default routine or in the lookup.
   -----------------------------------------------------------------------------
   function Lookup (Word : in String) return String;
   function Lookup (Word : in String) return Integer;

   function Lookup
     (Word    : in String;
      Default : in String
     ) return String;
   function Lookup
     (Word    : in String;
      Default : in Integer
     ) return Integer;

   -----------------------------------------------------------------------------
   -- Set a default definition for the given Word in the dictionary. If there is
   -- already a definition for the word, the previous definition will be used
   -- instead of the one supplied here.
   --
   -- This routine is useful to prevent Undefined_Word exceptions from Lookup.
   -----------------------------------------------------------------------------
   procedure Default
     (Word       : in String;
      Definition : in String := ""
     );
   procedure Default
     (Word       : in String;
      Definition : in Integer := 0
     );

end Simulation_Dictionary;
