/*-----------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-----------------------------------------------------------------------------*/

#ifndef reusable_cat
#define reusable_cat

/*--------------------------------------------------------------------------
-- Lookup the given word in the dictionary, and return its definition.
-- This routine is a C-wrapper for the Simulation_Dictionary.Lookup routine.
-- It dynamicly allocates memory for the result string. It is the caller's
-- responsibility to deallocate this memory.
---------------------------------------------------------------------------*/
char* JPATS_Dictionary_Lookup (char* Word);

#define JPATS_Log_Informational 0
#define JPATS_Log_Warning       1
#define JPATS_Log_Error         2
#define JPATS_Log_Fatal         3

/*--------------------------------------------------------------------------
-- Report an event to the log from a C unit. This is a C wrapper to the Ada
-- Log.Report routine
----------------------------------------------------------------------------*/
void JPATS_Log_Report (char* Event, int Severity);

/*--------------------------------------------------------------------------
-- Wait for all pending long messages to be processed. This is a C wrapper
-- to the Ada Log.Wait routine.
--------------------------------------------------------------------------*/
void JPATS_Log_Wait ();

#endif
